//
//  ViewController.m
//  
//


#import "ViewController.h"
#import "BindViewController.h"
#import "UIImage+GIF.h"
#import <JYouLoginKit/REDeLoginKit.h>

#define kMainScreenWidth        (float)([[UIScreen mainScreen] currentMode].size.width / 2.0f)
#define kMainScreenHeight       (float)([[UIScreen mainScreen] currentMode].size.height / 2.0f)

@interface ViewController ()<REDeLoginCallback,REDeBuyCallback,REDeRestoreCallback, REProductInfoCallback
>{
    NSTimer *_time;
}
@property (nonatomic, strong) UIImageView *imgView;
@property (nonatomic, strong) UIImage *imageH;
@property (nonatomic, strong) UIImage *imageS;
@end

@implementation ViewController

#pragma mark -
#pragma mark - init & dealloc

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

// iphoneX系列设备自动隐藏home键
- (BOOL)prefersHomeIndicatorAutoHidden
{
    return YES;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    [self demoConfig];
    //注册登录监听者
    [REDeLoginKit setFunctionLoginCallback:self];
    //注册支付监听者
    [REDeLoginKit setFunctionBuyCallback:self];
    [self buttonsConfig];
}

- (void)viewDidAppear:(BOOL)animated{
    [super viewDidAppear:animated];
}
- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
- (BOOL)shouldAutorotate{
    return YES;
}
//- (UIInterfaceOrientationMask)supportedInterfaceOrientations{
//    return UIInterfaceOrientationMaskPortrait;
//    return UIInterfaceOrientationMaskLandscape;
//}
#pragma mark - btn clicked
- (void)actionOnAccountDeletion {
    [REDeLoginKit accountDeletion];
}
- (void)actionOnRating {
    [REDeLoginKit showAppCommentWithAppID:@""];
}
- (void)loginBtnClicked:(id)sender{
   [REDeLoginKit loginWithMenuShow:YES];
}
- (void)actionOnFBShare {
    [REDeLoginKit fbSharePhoto:[UIImage imageNamed:@"1080-1920.jpg"] caption:@"" tag:@"tag nullable" completeWithResults:^(NSError *error, NSInteger status) {
        if (status == 0) {
            NSLog(@"FBShareSuccess");
        }else if(status == 1){
            NSLog(@"FBShareFail=%@",error.description);
        }else{
            NSLog(@"userCancelFBShare");
        }
    }];
//    [REDeLoginKit fbShareUrl:@"https://developers.facebook.com" quote:@"" tag:@"话题标签可为空" completeWithResults:^(NSError *error, NSInteger status) {
//        if (status == 0) {
//            NSLog(@"FBShareSuccess");
//        }else if(status == 1){
//            NSLog(@"FBShareFail=%@",error.description);
//        }else{
//            NSLog(@"userCancelFBShare");
//        }
//    }];
}
- (void)loginOutBtnClicked:(id)sender{
    [REDeLoginKit logout];

}
- (void)BtnClicked:(id)sender{
    [REDeLoginKit restoreNonConsumptionProducts:self];
}
- (void)actionOnFindProductsInfo:(UIButton *)sender {
    [REDeLoginKit findProductInfoWithProductIds:@[@"com.jy.product.xiaohao1", @"com.jy.product.xiaohao2", @"com.jy.product.dingyue2", @"com.jy.product.dingyue4", @"com.jy.product.autoDingyue1", @"com.jy.product.autoBuy1"] delegate:self];
}
- (void)userCenterBtnClicked:(id)sender{
    if ([REDeLoginKit userID].length < 1) {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"" message:@"PleaseLogin" delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
        [alert show];
        return;
    }
    
}
- (void)customerCenterBtnClicked:(id)sender{
    [REDeLoginKit enterUserCenter];
}
- (void)goumaiBtnClicked:(id)sender{
    if ([REDeLoginKit userID].length < 1) {
        [self alerWithMsg:@"PleaseLogin"];
        return;
    }
    UIAlertController * vc = [UIAlertController alertControllerWithTitle:@"Tips" message:@"PleaseInputInformation" preferredStyle:UIAlertControllerStyleAlert];
    [vc addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder = @"PleaseInputProductName";
        textField.text = @"BaoShi";
    }];
    [vc addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder = @"PleaseInputProductID";
        textField.text = @"com.jy.product.xiaohao1";
    }];
    [vc addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder = @"PleaseInputProductPrice";
        textField.text = @"6";
    }];
    [vc addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder = @"PleaseInputCount";
        textField.text = @"1";
    }];
    UIAlertAction * action = [UIAlertAction actionWithTitle:@"Sure" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        NSTimeInterval timeInterval = [NSDate.date timeIntervalSince1970];
        REDeOrderInfo *param = [REDeOrderInfo infoWithProductId:[vc.textFields objectAtIndex:1].text orderNo:[NSString stringWithFormat:@"%.0f", timeInterval] subject:[vc.textFields objectAtIndex:0].text total:@""];
        param.price = [vc.textFields objectAtIndex:2].text;
        param.quantity = [[vc.textFields objectAtIndex:3].text intValue] ? [[vc.textFields objectAtIndex:3].text intValue] :1;
        param.callback_url = @"";//回调通知地址 string[200] 可选，（可后台配置，后台配置了回调地址就以后台配置的为准）
        param.total = [NSString stringWithFormat:@"%.2f", param.price.floatValue*param.quantity];
        param.extras_params = [vc.textFields objectAtIndex:1].text;
        [REDeLoginKit IAPWithParameter:param];
    }];
    [vc addAction:action];
    [self presentViewController:vc animated:YES completion:nil];
}
- (void)actionOnTransactionRefund:(UIButton *)sender {
    if (@available(iOS 15.0, *)) {
        __weak typeof(self) weakself = self;
        UIAlertController * vc = [UIAlertController alertControllerWithTitle:@"Tip" message:@"PleaseInputInformation" preferredStyle:UIAlertControllerStyleAlert];
        [vc addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
            textField.placeholder = @"PleaseInputTransactionID";
            textField.text = @"2000000363776090";
        }];
        UIAlertAction * action = [UIAlertAction actionWithTitle:@"Sure" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            [REDeLoginKit showRefundWithTransactionID:vc.textFields.firstObject.text];
        }];
        UIAlertAction * cancelAction = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
            
        }];
        [vc addAction:action];
        [vc addAction:cancelAction];
        [self presentViewController:vc animated:YES completion:nil];

    }
}
- (void)actionOnOfferCode:(UIButton *)sender {
    if (@available(iOS 16.0, *)) {
        [REDeLoginKit showOfferCodeRedeemSheetUI];
    }
}
- (void)showTopMenuBtnClicked:(id)sender{
    if ([REDeLoginKit userID].length < 1) {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"" message:@"PleaseLogin" delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
        [alert show];
        return;
    }
    [REDeLoginKit showFloatButtonIsLeft:YES buttonOriginalY:60];
}
- (void)dismissTopMenuBtnClicked:(id)sender{
    [REDeLoginKit dismissMenu];
}
- (void)changeOrientationBtnClicked:(id)sender{
    if ([REDeLoginKit userID].length < 1) {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"" message:@"PleaseLogin" delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
        [alert show];
        return;
    }
    BindViewController * vc = [BindViewController new];
    vc.modalTransitionStyle = UIModalTransitionStyleCrossDissolve;
    vc.modalPresentationStyle = UIModalPresentationOverCurrentContext;
    [self presentViewController:vc animated:YES completion:nil];
//    BOOL isLandscape = [[NSUserDefaults standardUserDefaults]boolForKey:APP_CONFIG_ORIENTATION_KEY];
//    isLandscape = !isLandscape;
//    [[NSUserDefaults standardUserDefaults]setBool:isLandscape forKey:APP_CONFIG_ORIENTATION_KEY];
//    [[NSUserDefaults standardUserDefaults]synchronize];
//    if (isLandscape) {
//        [REDeLoginKit setPlatformOrientation:UIInterfaceOrientationMaskLandscape];
//    }else{
//        [REDeLoginKit setPlatformOrientation:UIInterfaceOrientationMaskPortrait];
//    }
//    UIWindow *startWindow = [[UIApplication sharedApplication] windows].firstObject;
//    startWindow.rootViewController = nil;
//    startWindow.rootViewController = [[ViewController alloc]init];
}
- (void)onfastlyBeginGame{
    [REDeLoginKit fastlyStartGame];
}
#pragma mark -REDeLoginCallback
// 登录成功回调
- (void)loginUid:(NSString *)uid userToken:(NSString *)token
{
    NSLog(@"callbackloginSuccess:\nUID:%@,token:%@",uid,token);
    if([REDeLoginKit isUserGuest]){
        NSLog(@"isGuestAccount");
    }else{
        NSLog(@"notGuestAccount");
    }
    //显示隐藏浮动菜单
//    [REDeLoginKit dismissMenu];
//    [REDeLoginKit showMenu:TopMenuButtonPositionLeft|TopMenuButtonPositionUpside];
    //设置角色
    REDeRoleInfo *role = [REDeRoleInfo new];
    role.game_role_id = [REDeLoginKit userID];
    role.server_name = @"testServer";
    role.game_role_name = [NSString stringWithFormat:@"%@%@",role.game_role_id,@"roleName"];
    role.game_role_level = @"13";
    role.game_role_balance = @"0";
    role.game_role_party_name = @"iOS";
    [REDeLoginKit setGameRoleInfo:role];
}
- (void)loginUid:(NSString *)uid userToken:(NSString *)token type:(USERCENTER_TYPE)type {
    NSLog(@"callbackloginSuccess:\nUID:%@,token:%@,type=%d",uid,token, type);
}
// 用户从个人中心手动登出回调
- (void)userLogout
{
    NSLog(@"%s", __func__);
    NSLog(@"userClickLogoutCallback");
}
// 游戏主动调用logout成功回调
- (void)gameLogoutSuccess {
    NSLog(@"%s", __func__);
    NSLog(@"gameCallLogoutCaback");
}
// 绑定回调
- (void)bindUid:(NSString *)uid userToken:(NSString *)token type:(USERCENTER_TYPE)type
{
    NSLog(@"%s", __func__);
    NSDictionary *dic = [REDeLoginKit getUserBindInfo];
    if ([dic.allKeys containsObject:@"USERCENTER_TYPE_EMAIl"]) {
         if ([dic[@"USERCENTER_TYPE_EMAIl"] boolValue]) {
               NSLog(@"emailBindsuccess");
           }
    }
   
}
- (void)unBindUid:(NSString *)uid userToken:(NSString *)token type:(USERCENTER_TYPE)type
{
    NSLog(@"%s", __func__);
}
- (void)onClickServiceCenter {
    NSLog(@"%s", __func__);
}
- (void)sdkUserPageWiIlClose {
    NSLog(@"%s", __func__);
}
#pragma mark -REDeBuyCallback
// 支付成功回调
- (void)purchaseDoneProductId:(NSString *)productId orderNo:(NSString *)orderNo gameOrderNo:(NSString *)gameOrderNo appStoreReceiptBase64EncodedString:(NSString *)receiptString
{
    NSLog(@"purchaseDoneOrderNo：%@",orderNo);
}
// 支付失败回调
- (void)purchaseFail
{
    NSLog(@"purchaseFail");
}
#pragma mark -REDeRestoreCallback
//恢复非消耗商品成功，返回商品id信息
- (void)restoreSuccess:(NSArray *)products
{
    NSLog(@"restoreSuccess：%@",products);
}
//恢复失败
- (void)restoreFail:(NSString *)msg
{
    NSLog(@"restoreFail：%@",msg);
}
#pragma mark -REProductInfoCallback
//查找商品信息成功数组元素为REDeOrderInfo实例
- (void)findProductInfoSuccess:(NSArray *)products {
    for (REDeOrderInfo * info in products) {
        NSLog(@"findProductInfoSuccess：productId=%@,productname=%@，productdes=%@，productprice=%@，amount=%@，productcurrentcy=%@",info.productId, info.subject, info.desc, info.price, info.total, info.extras_params);
    }
}
//查找商品信息失败
- (void)findProductInfoFail:(NSString *)msg {
    NSLog(@"findProductInfoFail：%@",msg);

}
#pragma mark -
- (void)closeAlert:(UIAlertView *)alert{
    [alert dismissWithClickedButtonIndex:0 animated:YES];
    alert = nil;
}
- (void)buttonsConfig {
    for (UIView * subView in self.view.subviews) {
        if ([subView isKindOfClass:UIButton.class]) {
            [subView removeFromSuperview];
        }
    }
    float btnWith = UIScreen.mainScreen.bounds.size.width > 320 ? 160:140, btnHeight = 40;
    float yBegin = 40;
    float yDistance = 10;
    int count = 0;
    int lineCount = UIScreen.mainScreen.bounds.size.width > UIScreen.mainScreen.bounds.size.height ? 3:2;
    float xbegin = lineCount > 2 ? 20:UIScreen.mainScreen.bounds.size.width*0.5-btnWith-10;
    float xspace = lineCount > 2 ? 10:20;
    _logButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [_logButton setBackgroundColor:[UIColor grayColor]];
    [_logButton setTitle:@"Login" forState:UIControlStateNormal];
    [_logButton setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
    [_logButton addTarget:self action:@selector(loginBtnClicked:) forControlEvents:UIControlEventTouchUpInside];
    [_logButton setFrame:CGRectMake(xbegin, yBegin, btnWith, btnHeight)];
    count += 1;
    [self.view addSubview:_logButton];
    
    
    // Do any additional setup after loading the view.
    _logoutButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [_logoutButton setBackgroundColor:[UIColor clearColor]];
    [_logoutButton setTitle:@"Logout" forState:UIControlStateNormal];
    [_logoutButton setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
    [_logoutButton addTarget:self action:@selector(loginOutBtnClicked:) forControlEvents:UIControlEventTouchUpInside];
    [_logoutButton setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
    count += 1;
    [self.view addSubview:_logoutButton];
    // 购买
    _userCenterButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [_userCenterButton setBackgroundColor:[UIColor clearColor]];
    [_userCenterButton setTitle:@"Pay" forState:UIControlStateNormal];
    [_userCenterButton setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
    [_userCenterButton addTarget:self action:@selector(goumaiBtnClicked:) forControlEvents:UIControlEventTouchUpInside];
    [_userCenterButton setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
    count += 1;
    [self.view addSubview:_userCenterButton];
    //    用户中心
    _customerCenterBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [_customerCenterBtn setTitle:@"UserCenter" forState:UIControlStateNormal];
    [_customerCenterBtn setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
    [_customerCenterBtn addTarget:self action:@selector(customerCenterBtnClicked:) forControlEvents:UIControlEventTouchUpInside];
    [_customerCenterBtn setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
    count += 1;
    [self.view addSubview:_customerCenterBtn];
    //  恢复购买
    _chongziButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [_chongziButton setBackgroundColor:[UIColor clearColor]];
    [_chongziButton setTitle:@"Restore" forState:UIControlStateNormal];
    [_chongziButton setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
    [_chongziButton addTarget:self action:@selector(BtnClicked:) forControlEvents:UIControlEventTouchUpInside];
    [_chongziButton setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
    count += 1;
    [self.view addSubview:_chongziButton];
    //    显示浮动图标
    _showTopMenuBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [_showTopMenuBtn setBackgroundColor:[UIColor clearColor]];
    [_showTopMenuBtn setTitle:@"ShowMenuBtn" forState:UIControlStateNormal];
    [_showTopMenuBtn setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
    [_showTopMenuBtn addTarget:self action:@selector(showTopMenuBtnClicked:) forControlEvents:UIControlEventTouchUpInside];
    [_showTopMenuBtn setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
    count += 1;
    [self.view addSubview:_showTopMenuBtn];
    //    隐藏浮动图标
    _dismissTopMenuBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [_dismissTopMenuBtn setBackgroundColor:[UIColor clearColor]];
    [_dismissTopMenuBtn setTitle:@"HideMenuBtn" forState:UIControlStateNormal];
    [_dismissTopMenuBtn setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
    [_dismissTopMenuBtn addTarget:self action:@selector(dismissTopMenuBtnClicked:) forControlEvents:UIControlEventTouchUpInside];
    [_dismissTopMenuBtn setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
    count += 1;
    [self.view addSubview:_dismissTopMenuBtn];
    
    //  改变方向 这个是ksd之外的内容
    _changeOrintationBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [_changeOrintationBtn setBackgroundColor:[UIColor clearColor]];
    [_changeOrintationBtn setTitle:@"Bind/Unbind" forState:UIControlStateNormal];
    [_changeOrintationBtn setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
    [_changeOrintationBtn addTarget:self action:@selector(changeOrientationBtnClicked:) forControlEvents:UIControlEventTouchUpInside];
    [_changeOrintationBtn setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
    count += 1;
    [self.view addSubview:_changeOrintationBtn];
    {
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
        [btn setBackgroundColor:[UIColor clearColor]];
        [btn setTitle:@"FastBeginGame" forState:UIControlStateNormal];
        [btn setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
        [btn addTarget:self action:@selector(onfastlyBeginGame) forControlEvents:UIControlEventTouchUpInside];
        [btn setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
        count += 1;
        [self.view addSubview:btn];
    }
    {
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
        [btn setBackgroundColor:[UIColor clearColor]];
        [btn setTitle:@"ProductsInfo" forState:UIControlStateNormal];
        [btn setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
        [btn addTarget:self action:@selector(actionOnFindProductsInfo:) forControlEvents:UIControlEventTouchUpInside];
        [btn setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
        count += 1;
        [self.view addSubview:btn];
    }
    if (@available(iOS 15.0, *)) {
        {
            UIButton *btn1 = [UIButton buttonWithType:UIButtonTypeCustom];
            [btn1 setBackgroundColor:[UIColor clearColor]];
            [btn1 setTitle:@"managersubscriptions" forState:UIControlStateNormal];
            [btn1 setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
            [btn1 addTarget:self action:@selector(actionOnManagersubscriptions:) forControlEvents:UIControlEventTouchUpInside];
            [btn1 setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+10), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
            count += 1;
            [btn1 setAutoresizingMask:UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleLeftMargin|UIViewAutoresizingFlexibleRightMargin];
            [self.view addSubview:btn1];
        }
        {
            UIButton *btn1 = [UIButton buttonWithType:UIButtonTypeCustom];
            [btn1 setBackgroundColor:[UIColor clearColor]];
            [btn1 setTitle:@"TransactionRefund" forState:UIControlStateNormal];
            [btn1 setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
            [btn1 addTarget:self action:@selector(actionOnTransactionRefund:) forControlEvents:UIControlEventTouchUpInside];
            [btn1 setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+10), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
            count += 1;
            [btn1 setAutoresizingMask:UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleLeftMargin|UIViewAutoresizingFlexibleRightMargin];
            [self.view addSubview:btn1];
        }
        if (@available(iOS 16.0, *)) {
            UIButton *btn1 = [UIButton buttonWithType:UIButtonTypeCustom];
            [btn1 setBackgroundColor:[UIColor clearColor]];
            [btn1 setTitle:@"OfferCode" forState:UIControlStateNormal];
            [btn1 setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
            [btn1 addTarget:self action:@selector(actionOnOfferCode:) forControlEvents:UIControlEventTouchUpInside];
            [btn1 setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+10), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
            count += 1;
            [btn1 setAutoresizingMask:UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleLeftMargin|UIViewAutoresizingFlexibleRightMargin];
            [self.view addSubview:btn1];
        }
    }
    {
        UIButton *btn1 = [UIButton buttonWithType:UIButtonTypeCustom];
        [btn1 setBackgroundColor:[UIColor clearColor]];
        [btn1 setTitle:@"FBShare" forState:UIControlStateNormal];
        [btn1 setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
        [btn1 addTarget:self action:@selector(actionOnFBShare) forControlEvents:UIControlEventTouchUpInside];
        [btn1 setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
        count += 1;
        [self.view addSubview:btn1];
    }
    {
        UIButton *btn1 = [UIButton buttonWithType:UIButtonTypeCustom];
        [btn1 setBackgroundColor:[UIColor clearColor]];
        [btn1 setTitle:@"AccountDeletion" forState:UIControlStateNormal];
        [btn1 setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
        [btn1 addTarget:self action:@selector(actionOnAccountDeletion) forControlEvents:UIControlEventTouchUpInside];
        [btn1 setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
        count += 1;
        [self.view addSubview:btn1];
    }
    {
        UIButton *btn1 = [UIButton buttonWithType:UIButtonTypeCustom];
        [btn1 setBackgroundColor:[UIColor clearColor]];
        [btn1 setTitle:@"rating" forState:UIControlStateNormal];
        [btn1 setTitleColor:[UIColor blueColor] forState:UIControlStateHighlighted];
        [btn1 addTarget:self action:@selector(actionOnRating) forControlEvents:UIControlEventTouchUpInside];
        [btn1 setFrame:CGRectMake(xbegin + count%lineCount*(btnWith+xspace), yBegin+(count/lineCount)*(btnHeight+yDistance), btnWith, btnHeight)];
        count += 1;
        [self.view addSubview:btn1];
    }
}
- (void)demoConfig
{
    self.view.layer.contents = (__bridge id _Nullable)([UIImage imageNamed:@"1080-1920.jpg"].CGImage);
    self.imgView = [[UIImageView alloc] init];
    self.imgView.contentMode = UIViewContentModeScaleToFill;
    [self.view insertSubview:self.imgView atIndex:0];
    self.imgView.translatesAutoresizingMaskIntoConstraints = NO;
    NSLayoutConstraint *constraintTop = [NSLayoutConstraint constraintWithItem:self.imgView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    NSLayoutConstraint *constraintLeft = [NSLayoutConstraint constraintWithItem:self.imgView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    NSLayoutConstraint *constraintBottom = [NSLayoutConstraint constraintWithItem:self.imgView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    NSLayoutConstraint *constraintRight = [NSLayoutConstraint constraintWithItem:self.imgView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self.view addConstraints:@[constraintTop,constraintLeft,constraintBottom,constraintRight]];
    
    NSString *path = [[NSBundle mainBundle] pathForResource:@"bg_heng" ofType:@"gif"];
    NSData *data = [NSData dataWithContentsOfFile:path];
    self.imageH = [UIImage sd_animatedGIFWithData:data];
    NSString *path1 = [[NSBundle mainBundle] pathForResource:@"bg_shu" ofType:@"gif"];
    NSData *data1 = [NSData dataWithContentsOfFile:path1];
    self.imageS = [UIImage sd_animatedGIFWithData:data1];

    if ([UIApplication sharedApplication].statusBarOrientation == UIInterfaceOrientationPortrait) {
        self.imgView.image = self.imageS;
    } else {
        self.imgView.image = self.imageH;
    }

    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(deviceOrientationDidChange:)
                                                 name:UIApplicationDidChangeStatusBarFrameNotification
                                               object:nil
     ];
}
#pragma mark - 监听屏幕旋转
- (void)deviceOrientationDidChange:(UIInterfaceOrientation)interfaceOrientation{
    switch ([UIDevice currentDevice].orientation) {
        case UIDeviceOrientationLandscapeLeft:
        case UIDeviceOrientationLandscapeRight: {
            self.imgView.image = self.imageH;
        }
            break;
        case UIDeviceOrientationPortrait:
        case UIDeviceOrientationPortraitUpsideDown: {
            self.imgView.image = self.imageS;
        }
            break;
        default:
            break;
    }
    [self buttonsConfig];
}
#pragma mark - private methods
- (void)alerWithMsg:(NSString *)msg {
    UIAlertController * vc = [UIAlertController alertControllerWithTitle:@"Tips" message:msg preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction * action = [UIAlertAction actionWithTitle:@"Sure" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    [vc addAction:action];
    [self presentViewController:vc animated:YES completion:nil];
}
@end
