//
//  BindViewController.m
//  haiwaizui_Flyer
//
//  Created by macMini on 2020/12/16.
//

#import "BindViewController.h"
#import <JYouLoginKit/REDeLoginKit.h>

@interface BindViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (weak, nonatomic) IBOutlet UITableView *tableView;
@property (nonatomic, strong) NSMutableArray * bindStatusArr;
@end

@implementation BindViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    _bindStatusArr = [NSMutableArray arrayWithCapacity:0];
    [self reloadData];
}
- (IBAction)actionOnCloseBtn:(UIButton *)sender {
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _bindStatusArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"123"];
    if (!cell) {
        cell
        = [[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"123"];
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.textLabel.textAlignment = NSTextAlignmentCenter;
    NSArray * valueArr = [_bindStatusArr[indexPath.row] allValues].firstObject;
    cell.textLabel.text = [NSString stringWithFormat:@"%@%@", [valueArr.firstObject boolValue] ? @"unBind":@"Bind", valueArr.lastObject];
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    USERCENTER_TYPE type = [[_bindStatusArr[indexPath.row]allKeys].firstObject intValue];
    NSArray * valueArr = [_bindStatusArr[indexPath.row] allValues].firstObject;
    if ([valueArr.firstObject boolValue]) {
        [REDeLoginKit unbindAccount:type];
        [self dismissViewControllerAnimated:YES completion:nil];
        return;
    }
    [REDeLoginKit bindAccountType:type];
    [self dismissViewControllerAnimated:YES completion:nil];
}
- (void)reloadData {
    NSDictionary * bindInfo = [REDeLoginKit getUserBindInfo];
    if ([[bindInfo objectForKey:@"USERCENTER_TYPE_FB"] boolValue]) {
        NSLog(@"绑定了Facebook");
    } else {
        NSLog(@"未绑定FaceBook");
    }
//    _dataArr = @[ @{@"16":@"Apple"}, @{@"6":@"Facebook"}, @{@"10":@"Twitter"}, @{@"11":@"Line"}];
    if (_bindStatusArr.count) {
        [_bindStatusArr removeAllObjects];
    }
    [_bindStatusArr addObject:@{@"1":@[[bindInfo objectForKey:@"USERCENTER_TYPE_EMAIl"], @"Email"]}];
    [_bindStatusArr addObject:@{@"6":@[[bindInfo objectForKey:@"USERCENTER_TYPE_FB"], @"Facebook"]}];
    [_bindStatusArr addObject:@{@"8":@[[bindInfo objectForKey:@"USERCENTER_TYPE_GOOGLEPLUS"], @"Google"]}];
    [_bindStatusArr addObject:@{@"16":@[[bindInfo objectForKey:@"USERCENTER_TYPE_Apple"], @"Apple"]}];
    [_tableView reloadData];
}

@end
