//
//  CSParamModel.h

//

//

#import <Foundation/Foundation.h>

@interface CSParamModel : NSObject

// 必传参数
@property (nonatomic, strong) NSString *uId;         //用户uId
@property (nonatomic, strong) NSString *userName;    //用户名
@property (nonatomic, strong) NSString *userNickNameId;  //可选，当平台同账号下存在多个昵称时，可传入此值区分不用的昵称（角色id）
@property (nonatomic, strong) NSString *userNickName; //用户昵称（角色名）
@property (nonatomic, strong) NSString *userNickNameNote; //传入昵称的备注，此数据会在后端客服查看时与昵称一并显示（服务器名）
@property (nonatomic, strong) NSString *vipLevel;        //用户在平台的vip级别
@property (nonatomic, strong) NSString *userBalance; //虚拟货币余额

// 以下参数不传
@property (nonatomic, strong) NSString *channelCode; //随意填，可不填
@property (nonatomic, strong) NSString *title; //客服界面title，可不填
@property (nonatomic, strong) NSString *pushToken;  //苹果推送的token，可不填
@property (nonatomic, strong) NSString *statusBarHeight; //状态栏高度，可不填
@property (nonatomic, strong) NSString *bottomBarHeight; //工具栏高度，可不填
@property (nonatomic, strong) NSString *qgProductCode; //quickgameProductCode，可不填
@property (nonatomic, strong) NSString *qkProductCode; //quicksdkProductCode，可不填
@property (nonatomic, strong) NSString *authToken; //quickgame的authToken，可不填
@property (nonatomic, strong) NSString *checkToken; //quicksdk的 authtoken，可不填
@property (nonatomic, strong) NSString *qkUid; //quicksdkUid，可不填
@property (nonatomic, strong) NSString *inputArea; //键盘高度，可不填
@property (nonatomic, strong) NSString *problem; //客服问题，可不填

//获取一个默认值的参数，全部信息都为@""。
+ (instancetype)param;
@end
