//
//  CSManager.h
//
//
#define SDK_VERSION @"1.4.6"

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "CSParamModel.h"

typedef void (^KCloseServiesBlock)(void);
#define Notificaiton_DidCloseServiesystom @"DidCloseServiesystom"

@interface CSManager : NSObject
+ (instancetype)sharedInstance;//获取客服SDK单例

/**
 *客服系统设置appid和客服语言，该接口可多次调用设置多个appid用于支持不同的语言，一个appid对应一种语言，SDK会自动匹配设备当前语言来选择使用哪一个appid，需至少设置一种语言
 *@param language appid对应的客服语言，（简体中文@"zh-cn", 中文繁体香港@"zh-hk", 中文繁体台湾@"zh-tw", 德语@"de", 英语@"en-us", 法语@"fr", 日语@"ja-jp", 韩语@"kor", 俄语@"ru", 泰语@"th"）
 *@param appid 客服appid参数，参数在客服SDK后台申请
 */
- (void)setLanguage:(NSString *)language appid:(NSString *)appid;

//打开客服，上传参数请查看CSParamModel.h
- (void)enterServiesystem:(CSParamModel *)param;

/**
 *有新客服消息时接收本地通知
 *在- (void)application:(UIApplication *)application didReceiveLocalNotification:(nonnull UILocalNotification *)notification;中调用以获取新消息
 *@param application application参数
 *@param notification notification本地通知
 */
- (void)application:(UIApplication *)application didReceiveLocalNotification:(nonnull UILocalNotification *)notification;

/**
 *注册苹果远程通知APNS，用于远程通知推送消息，如果没有远程推送可以不调用
 *在- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions;中调用
 */
- (void)registerForRemoteNotifications;
/**
 *获取苹果返回的deviceToken用于接收远程推送通知，如果没有远程推送可以不调用
 *在- (void)application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken;中调用以获取推送的deviceToken
 *@param deviceToken 苹果返回的deviceToken
 */
- (void)didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken;

//显示客服浮动菜单
- (void)showMenu;
//隐藏客服浮动菜单
- (void)hideMenu;
//设置客服参数，可用于不调用enterServiesystem接口而是直接通过浮标打开客服系统
- (void)setParam:(CSParamModel *)param;
//关闭客服回调
- (void)didCloseServices:(KCloseServiesBlock)completion;
//关闭客服
- (void)closeServiesystom;

- (BOOL)application:(UIApplication *)app openURL:(NSURL *)url options:(NSDictionary<UIApplicationOpenURLOptionsKey,id> *)options;

- (BOOL)application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void (^)(NSArray<id<UIUserActivityRestoring>> * _Nullable))restorationHandler;

- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(UIWindow *)window;

@end
