//
//  AppDelegate.m
//  CustomerServiceDemo
//
//  Created by 0280106PC0119 on 2016/11/22.
//  Copyright © 2016年 quicksdk. All rights reserved.
//

#import "AppDelegate.h"
#import <CsSDK/CSManager.h>

@interface AppDelegate ()

@end

@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    // Override point for customization after application launch.
    
    //注册苹果远程通知（支持消息远程推送）
    [[CSManager sharedInstance] registerForRemoteNotifications];
    
    /**
     *设置客服系统appid和客服语言，一个appid对应一种语言，SDK会自动匹配设备当前语言来选择使用哪一个appid，需至少设置一种语言
     *支持的语言包含：（简体中文@"zh-cn", 中文繁体香港@"zh-hk", 中文繁体台湾@"zh-tw", 德语@"de", 英语@"en-us", 法语@"fr", 日语@"ja-jp", 韩语@"kor", 俄语@"ru", 泰语@"th"）
     */
    [[CSManager sharedInstance] setLanguage:@"fr" appid:@"94023578614113111989515645672059"];//法语
    [[CSManager sharedInstance] setLanguage:@"en-us" appid:@"61aade75fe4c32eb35eda06d4d39c005"];//英语
    [[CSManager sharedInstance] setLanguage:@"zh-cn" appid:@"11145220560844504323138980545377"];//中文简体
    [[CSManager sharedInstance] setLanguage:@"zh-tw" appid:@"22780358870497643540117482425477"];//中文繁体
    
    
    return YES;
}

// 当App在前台状态下，如果有通知会调用该方法
// 当应用程序在后台状态下，点击推送通知，程序从后台进入前台后，会调用该方法（从锁屏界面点击推送通知从后台进入前台也会执行）
// 当应用程序完全退出时不调用该方法
- (void)application:(UIApplication *)application didReceiveLocalNotification:(nonnull UILocalNotification *)notification {
    NSLog(@"%@", notification);
    [[CSManager sharedInstance] application:application didReceiveLocalNotification:notification];
}

// 获取苹果返回的deviceToken用于接收远程推送通知，如果没有远程推送可以不调用
- (void)application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken
{
    // 将DeviceToken传给服务器
    [[CSManager sharedInstance] didRegisterForRemoteNotificationsWithDeviceToken:deviceToken];
    NSLog(@"%@", deviceToken.description);
}

- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
}


- (void)applicationDidEnterBackground:(UIApplication *)application {
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(nullable UIWindow *)window
{
    return UIInterfaceOrientationMaskAll;
}

- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
}


- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}


- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}


@end
