package com.excelliance.open.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;

import com.excelliance.lbui.R;
import com.excelliance.open.BaseActivity;
import com.excelliance.open.BwbxUI;
import com.excelliance.open.utils.LayoutInflaterUtil;

/**
 * 上传对话框(自助分包)
 */
public class UploadDialog extends Dialog implements View.OnClickListener {

    private View.OnClickListener mOnClickListener;

    private boolean isUploading;
    protected Activity mActivity;

    public UploadDialog(Context context) {
        super(context);
        initDialogStyle();
        initView();
        mActivity = (Activity) context;
    }

    public UploadDialog(Context context, int themeResId) {
        super(context, themeResId);
        initDialogStyle();
        initView();
    }

    protected UploadDialog(Context context, boolean cancelable, OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        initDialogStyle();
        initView();
    }

    /**
     * 当始化dialog的主题theme.<br/>
     * 动态加载lbui.jar的方式, 暂时不能通过xml style方式设置theme
     */
    private void initDialogStyle() {
        getWindow().setBackgroundDrawableResource(android.R.color.transparent);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
    }

    private void initView() {
        Context context = getContext();
        Resources res = BwbxUI.getResources(context);
        Context newContext = new BaseActivity.LebianContext(context, android.R.style.Theme, res);
        LayoutInflater inflater = LayoutInflater.from(context);
        inflater = inflater.cloneInContext(newContext);
        LayoutInflaterUtil.disableFactory(context, inflater);
        View view = inflater.inflate(R.layout.lebian_upload, null);
        setContentView(view);

        findViewById(R.id.lebian_keep_small).setOnClickListener(this);
        findViewById(R.id.lebian_upload_record).setOnClickListener(this);
        findViewById(R.id.lebian_clear_data).setOnClickListener(this);
        findViewById(R.id.lebian_cancel).setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        int viewId = v.getId();

        View.OnClickListener l = mOnClickListener;
        if (null != l) {
            l.onClick(v);
        }
        if (viewId == R.id.lebian_cancel) {
            dismiss();
        }
    }

    /**
     * 设置点击事件监听器
     * @param l 监听器
     */
    public void setOnUploadClickListener(View.OnClickListener l) {
        this.mOnClickListener = l;
    }

    /**
     * 获取之前设置的事件监听器
     * @return 监听器
     */
    public View.OnClickListener getOnUploadClickListener() {
        return mOnClickListener;
    }
}
