package com.excelliance.open.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import com.excelliance.lbui.R;
import com.excelliance.open.AliveDialogLayer;
import com.excelliance.open.BaseActivity;
import com.excelliance.open.BwbxUI;
import com.excelliance.open.CustomInflaterFactory;
import com.excelliance.open.utils.LayoutInflaterUtil;

/**
 * 资源文件加载对话框
 */
public class LoadingDialog extends Dialog {

    public LoadingDialog(Context context, int theme) {
        super(context, theme);
    }

    public LoadingDialog(Context context) {
        super(context);
    }

    /**
     * 设置表示loading进度的文字
     * @param progress 文字内容
     */
    public void setProgress(String progress) {
        TextView textProgress = (TextView) this.findViewById(R.id.lebian_text_progress_loading);
        if (textProgress != null) {
            textProgress.setText(progress);
        }
    }

    /**
     * Helper class for creating a custom dialog
     */
    public static class Builder extends AliveDialogLayer.Builder {

        private Context context;
        private View contentView;
        private String progressText;
        private boolean canceledOnTouchOutside = true;
        private DialogInterface.OnKeyListener onKeyListener;

        private LoadingDialog selfDialog;

        public Builder(Context context) {
            super(context);
            this.context = new BaseActivity.LebianContext(context, android.R.style.Theme, BwbxUI.getResources(context));
        }

        /**
         * 设置表示loading进度的文字
         *
         * @param progress 文字内容
         * @return
         */
        public Builder setProgress(String progress) {
            this.progressText = progress;
            LoadingDialog dialog = selfDialog;
            if (null != dialog) {
                dialog.setProgress(progress);
            } else {
                invalidate();
            }
            return this;
        }

        @Override
        protected Dialog onCreate(Activity activity) {
            this.context = new BaseActivity.LebianContext(activity, android.R.style.Theme, BwbxUI.getResources(context));
            LayoutInflater inflater = (LayoutInflater) context
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            // instantiate the dialog with the custom Theme
            inflater = inflater.cloneInContext(context);
            LayoutInflaterUtil.disableFactory(context, inflater);

            CustomInflaterFactory factory = new CustomInflaterFactory(inflater.getFactory(), getClass().getClassLoader());
            inflater.setFactory(factory);

            final LoadingDialog dialog = new LoadingDialog(context, R.style.lebian_dialog_theme);
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);

            dialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
            dialog.setOnKeyListener(onKeyListener);

            View layout = contentView;
            if (null == layout) {
                layout = inflater.inflate(R.layout.lebian_progress_dialog, null);
            }
            dialog.setContentView(layout);

            dialog.getWindow().setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT);

            dialog.setProgress(progressText);
            selfDialog = dialog;
            return dialog;
        }

        public Builder setCanceledOnTouchOutside(boolean canceled) {
            canceledOnTouchOutside = canceled;
            return this;
        }

        public Builder setOnKeyListener(DialogInterface.OnKeyListener listener) {
            onKeyListener = listener;
            return this;
        }
    }

}


