package com.excelliance.open.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;

import com.excelliance.lbui.R;
import com.excelliance.open.BaseActivity;
import com.excelliance.open.BwbxUI;

/**
 * 简单的输入对话框
 */
public class InputDialog extends Dialog implements View.OnClickListener {
    private EditText mInput;
    private InputDialog.OnInputListener mListener;
    private TextView mTitle;

    /**
     * 输入监听器
     */
    public static interface OnInputListener {

        /**
         * 当输入窗口关闭时调用
         * @param which 用户点击按钮
         * @param input 输入内容
         */
        void onInput(int which, String input);
    }

    public InputDialog(Context context) {
        super(context);
        initDialogStyle(context);
        initView();
    }

    public InputDialog(Context context, int themeResId) {
        super(context, themeResId);
        initDialogStyle(context);
        initView();
    }

    protected InputDialog(Context context, boolean cancelable, OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        initDialogStyle(context);
        initView();
    }

    /**
     * 当始化dialog的主题theme.<br/>
     * 动态加载lbui.jar的方式, 暂时不能通过xml style方式设置theme
     */
    private void initDialogStyle(Context context) {
        getWindow().setBackgroundDrawableResource(android.R.color.transparent);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
    }

    private void initView() {
        Context context = getContext();
        Resources res = BwbxUI.getResources(context);
        Context newContext = new BaseActivity.LebianContext(context, android.R.style.Theme, res);
        View view = LayoutInflater.from(context).cloneInContext(newContext).inflate(R.layout.lebian_input, null);
        setContentView(view);

        findViewById(R.id.lebian_ok).setOnClickListener(this);
        findViewById(R.id.lebian_cancel).setOnClickListener(this);
        mInput = findViewById(R.id.lebian_input);
        mTitle = findViewById(R.id.lebian_title);
    }

    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        int which = 0;
        if (viewId == R.id.lebian_ok) {
            which = DialogInterface.BUTTON_POSITIVE;
        } else if (viewId == R.id.lebian_cancel) {
            which = DialogInterface.BUTTON_NEGATIVE;
        } else {
            // do nothing
        }
        String text = mInput.getText().toString();
        InputDialog.OnInputListener l = mListener;
        if (null != l) {
            l.onInput(which, text);
        }
        dismiss();
    }

    /**
     * 获取设置的输入事件监听器
     * @return null, 未设置
     */
    public OnInputListener getOnInputListener() {
        return mListener;
    }

    /**
     * 设置输入事件监听器
     * @param listener 监听器
     */
    public void setOnInputListener(OnInputListener listener) {
        this.mListener = listener;
    }

    @Override
    public void setTitle(CharSequence title) {
        super.setTitle(title);
        mTitle.setText(title);
    }
}
