package com.excelliance.open;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.CompoundButton;
import android.widget.TextView;

import com.excelliance.open.library.DialogClickCallback;
import com.excelliance.lbui.R;
import com.excelliance.open.custom.CustomClickCallback;
import com.excelliance.open.dialog.LoadingDialog;
import com.excelliance.open.utils.BitmapUtils;

public class UIDialogManager extends BaseUIHelper{
    public static final String TAG = "UIDialogManager";
    public static final int DIALOG_NEXTCHAPTER_EXIT = 101;//错误退出
    public static final int DIALOG_NEXTCHAPTER_UPDATE_DOWNLOAD_WITHOUT_WIFI = 102;//流量下热更提醒
    public static final int DIALOG_NEXTCHAPTER_DOWNLOAD_WITHOUT_WIFI = 103;//提示有更新下载
    public static final int DIALOG_NEXTCHAPTER_SPACE_NOT_ENOUGH = 104;//空间不足
    public static final int DIALOG_NEXTCHAPTER_UNFINISHED_WITHOUT_WIFI = 105;//下载过程流量切wifi
    public static final int DIALOG_NEXTCHAPTER_DOWNLOAD_BG_WITHOUT_WIFI = 106;//后台下载过程wifi切流量
    public static final int DIALOG_NEXTCHAPTER_SWITCH_GP = 107;//google play更新跳转

    public static final int DIALOG_PROMPT_UPDATE = 201;//热更提示
    public static final int DIALOG_PROMPT_DOWNLOAD_DIALOG = 202;//已经有热更好的版本提示重启
    public static final int DIALOG_PROMPT_INSTALL_DIALOG = 203;//提示已经有版本可以覆盖安装
    public static final int DIALOG_PROMPT_BWBX_FIRST = 204;//流量下第一次弹框
    public static final int DIALOG_PROMPT_CHOOSE_BY_USER = 205;//二次加载提醒
    public static final int DIALOG_PROMPT_MERGE_ERR_DIALOG = 206;//合并失败
    public static final int DIALOG_PROMPT_RESTART_FOR_JJ = 207;//重启
    public static final int DIALOG_PROMPT_LOADING_DIALOG = 208;//等待加载界面，一般就一个loading加背景图
    public static final int DIALOG_PROMPT_SPACE_NOT_ENOUGH = 209;//空间不足
    public static final int DIALOG_PROMPT_NETWORK_USELESS = 210;//没有网络
    public static final int DIALOG_PROMPT_SIGN_MIS_DOWNLOAD_FROM_URL = 211;//签名错误
    public static final int DIALOG_PROMPT_RES_PATCH = 212;//下载资源差分包
    public static final int DIALOG_PROMPT_SECID_ERR = 213;//配置错误
    public static final int DIALOG_PROMPT_TARGET_SDK_VERSION_ERR = 214;//target错误
    public static final int DIALOG_PROMPT_INVALID_PACKAGE = 215;//包不正确

    public static final int DIALOG_BWBXUI_DOWNLOAD_ERROR = 301;//下载错误
    public static final int DIALOG_BWBXUI_PROGRESS = 302;//咖啡杯
    public static final int DIALOG_BWBXUI_WIFI_TO_MOBILE = 303;//wifi切流量
    public static final int DIALOG_BWBXUI_BWBX_SECOND = 304;//流量下第二个弹框
    public static final int DIALOG_BWBXUI_BWBX_REMAINING_IN_MOBILE = 305;//接口调用showDownloadRemainingRes时，流量下或者总是弹出流量下第一个弹框时弹出
    public static final int DIALOG_BWBXUI_BWBX_REMAINING_IN_WIFI = 306;//接口调用showDownloadRemainingRes时,wifi下 弹出
    public static final int DIALOG_BWBXUI_BWBX_OLDER_USER = 307;//老用户，低网速，一次性下载弹框


    public static int ERR_NETWORK = -2;
    public static int ERR_SPACE_NOT_ENOUGH = -3;
    public static int ERR_TIMEOUT = -4;
    public static int ERR_MD5_MIS = -5;
    public static int ERR_RENAME_FAIL = -6;


    private final CustomClickCallback mCustomClickCallback;
    private final Context mContext;
    private Dialog mExitDialog;
    private AliveDialogLayer mDlWithoutWifiDialog;
    private AliveDialogLayer mUpdateWithoutWifiDialog;
    private AliveDialogLayer mNotEnoughSpaceDialog;
    private AliveDialogLayer mUnfinishedDlDialog;
    private AliveDialogLayer mDlBackgroundWithoutWifiDialog;
    private AliveDialogLayer mSwitchGPDialog;

    private AliveDialogLayer mBwbxErrorDialog;
    private AliveDialogLayer mProgressDialog;//咖啡杯
    private AliveDialogLayer mBwbxSecondDialog;//流量下第二个弹框
    private AliveDialogLayer mDownloadAllLaterInterface;
    private AliveDialogLayer mRemainingResDowning;
    private AliveDialogLayer mDownloadFullResDialog;//老用户，一次性下载，低网速
    private AliveDialogLayer mWifiToMobileDialog;//老用户，一次性下载，低网速


    /**
     * 对话框管理器, 以优先级方式弹出和维护弹出逻辑
     */
    private PopupGuard popupGuard = new PopupGuard();

    public UIDialogManager(Context context) {
        this.mContext = context;
        mCustomClickCallback = new CustomClickCallback(context);
    }

    //用于promptActivity或者nextchapter里的弹框
    public void show(int type,Bundle params,DialogClickCallback clickCallback) {
        switch (type) {
            case DIALOG_NEXTCHAPTER_EXIT:
                showExitDialog(type,clickCallback);
                break;
            case DIALOG_NEXTCHAPTER_UPDATE_DOWNLOAD_WITHOUT_WIFI:
                showUpdateWithoutWifiDialog(type,params,clickCallback);
                break;
            case DIALOG_NEXTCHAPTER_DOWNLOAD_WITHOUT_WIFI:
                showDlWithoutWifiDialog(type,params,clickCallback);
                break;
            case DIALOG_NEXTCHAPTER_SPACE_NOT_ENOUGH:
                showNotEnoughSpaceDialog(type,params,clickCallback);
                break;
            case DIALOG_NEXTCHAPTER_UNFINISHED_WITHOUT_WIFI:
                showUnfinishedDlDialog(type,params,clickCallback);
                break;
            case DIALOG_NEXTCHAPTER_DOWNLOAD_BG_WITHOUT_WIFI:
                showDlBackgroundWithoutWifiDialog(type,params,clickCallback);
                break;
            case DIALOG_NEXTCHAPTER_SWITCH_GP:
                showSwitchGPDialog(type, params, clickCallback);
                break;
            case DIALOG_PROMPT_UPDATE:
                showUpdateDialog(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_DOWNLOAD_DIALOG:
                showDownloadedDialog(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_INSTALL_DIALOG:
                showInstallDialog(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_BWBX_FIRST:
                showDownloadAll(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_CHOOSE_BY_USER:
                showChooseBwbx(type,params,clickCallback, null);
                break;
            case DIALOG_PROMPT_MERGE_ERR_DIALOG:
                showMergeErrDialog(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_RESTART_FOR_JJ:
                showRestartDialogForJJ(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_LOADING_DIALOG:
                showLoadingDialog(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_SPACE_NOT_ENOUGH:
                showNotEnoughSpaceDialog(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_NETWORK_USELESS:
                showNotNetworkDialog(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_SIGN_MIS_DOWNLOAD_FROM_URL:
                showDloadFromWebsite(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_RES_PATCH:
                showChooseResPatch(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_SECID_ERR:
                showSecIdErrDialog(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_TARGET_SDK_VERSION_ERR:
                showTargetSdkVersionErrDialog(type,params,clickCallback);
                break;
            case DIALOG_PROMPT_INVALID_PACKAGE:
                showInvalidPackageDialog(type,params, clickCallback);
                break;
            default:
                break;
        }
    }

    //用于 BWBXUI 里的弹框
    public void show(int type,boolean show,Activity activity,Bundle params,DialogClickCallback clickCallback) {
        if (mContext == null || activity == null) {
            return;
        }
        switch (type) {
            case DIALOG_BWBXUI_DOWNLOAD_ERROR:
                showGameDialog(type,show,activity,params,clickCallback);
                break;
            case DIALOG_BWBXUI_PROGRESS:
                showProgressDialog(type,show,activity,params,clickCallback);
                break;
            case DIALOG_BWBXUI_WIFI_TO_MOBILE:
                showWifiToMobile(type,show,activity,params,clickCallback);
                break;
            case DIALOG_BWBXUI_BWBX_SECOND:
                showDownloadAllLater(type,show,activity,params,clickCallback);
                break;
            case DIALOG_BWBXUI_BWBX_REMAINING_IN_MOBILE:
                showDownloadAllLaterInterface(type,show,activity,params,clickCallback);
                break;
            case DIALOG_BWBXUI_BWBX_REMAINING_IN_WIFI:
                showRemainingResDownloading(type,show,activity,params,clickCallback);
                break;
            case DIALOG_BWBXUI_BWBX_OLDER_USER:
                showDownloadFullRes(type, show, activity, params, clickCallback);
                break;
            case DIALOG_PROMPT_CHOOSE_BY_USER:
                showChooseBwbx(type,params,clickCallback, activity);
                break;
            default:
        }
    }

    public void autoDismiss(int dialogType) {
        switch (dialogType){
            case DIALOG_NEXTCHAPTER_UNFINISHED_WITHOUT_WIFI:
                if (mUnfinishedDlDialog != null && mUnfinishedDlDialog.isShowing()) {
                    mUnfinishedDlDialog.dismiss();
                }
                break;
            case DIALOG_NEXTCHAPTER_DOWNLOAD_WITHOUT_WIFI:
                if (mDlWithoutWifiDialog != null && mDlWithoutWifiDialog.isShowing()) {
                    mDlWithoutWifiDialog.dismiss();
                }
                break;
            case DIALOG_NEXTCHAPTER_UPDATE_DOWNLOAD_WITHOUT_WIFI:
                if (mUpdateWithoutWifiDialog != null && mUpdateWithoutWifiDialog.isShowing()) {
                    mUpdateWithoutWifiDialog.dismiss();
                }
                break;
        }

    }

    private String getString(int id) {
        String str;
        if (mContext instanceof PromptActivity || mContext instanceof NextChapterNew) {
            str = mContext.getResources().getString(id);
        } else {
            str = getResources(mContext).getString(id);
        }
        return str;
    }

    private boolean isFinishing() {
        boolean isFinishing = false;
        if (mContext instanceof Activity) {
            isFinishing = ((Activity) mContext).isFinishing();
        }

        return isFinishing;
    }

    private void showExitDialog(final int dialogType,final DialogClickCallback clickCallback) {
        if (mExitDialog == null) {
            AlertDialog.Builder builder = new AlertDialog.Builder(mContext);
            builder.setMessage(getString(R.string.lebian_exit_dialog_titile));

            builder.setTitle(getString(R.string.lebian_hint));

            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    clickCallback.onPositiveClick(dialogType,null);
                }
            });

            builder.setNegativeButton(getString(R.string.lebian_button_cancel), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            mExitDialog = builder.create();
            mExitDialog.setCancelable(false);
            mExitDialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
                @Override
                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    return keyCode == KeyEvent.KEYCODE_SEARCH;
                }
            });
        }
        if (!mExitDialog.isShowing() && !isFinishing()) {
            mExitDialog.show();
        }
    }

    private void showNotEnoughSpaceDialog(int dialogType,Bundle params, DialogClickCallback clickCallback) {
        long rSize = params.getLong("size");
        NewCustomDialog.Builder builder;
        if (mNotEnoughSpaceDialog == null) {
//            boolean hasSD = android.os.Environment.getExternalStorageState().equals(android.os.Environment.MEDIA_MOUNTED);
            builder = new NewCustomDialog.Builder(mContext);
            builder.setTitle(getString(R.string.lebian_not_enought_space));
            long requiredSize = rSize;
//            if (!hasSD){
                requiredSize += (20 << 20);
//            }
            String body = String.format(getString(R.string.lebian_storage_space_requirement_dload), requiredSize / (float) (1024 * 1024), getString(R.string.lebian_storage_phone));
            builder.setMessage(body);

            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mNotEnoughSpaceDialog);
                }
            });
            builder.setCancelable(false);
            builder.setOnKeyListener(new DialogInterface.OnKeyListener() {
                @Override
                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    return keyCode == KeyEvent.KEYCODE_SEARCH;
                }
            });
            createDialogCommon(builder,false);
            mNotEnoughSpaceDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder) mNotEnoughSpaceDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mNotEnoughSpaceDialog, (Activity) mContext);
    }

    private void showDlWithoutWifiDialog(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        long rSize = params.getLong("size");
        boolean forceUpdate = params.getBoolean("forceUpdate");
        boolean dataConnection = params.getBoolean("dataConnection");
        NewCustomDialog.Builder builder;
        if (mDlWithoutWifiDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            int resId = R.string.lebian_dl_update_without_wifi;
            int resId2 = R.string.lebian_dl_update_wifi;
            builder.setMessage(String.format(getString(dataConnection ? resId : resId2), ((float) (rSize)) / (1024.0f * 1024.0f)));

            builder.setTitle(getString(R.string.lebian_hint));

            if (!forceUpdate) {
                builder.setCheckBox(getString(R.string.lebian_next_no_prompt), false, new CompoundButton.OnCheckedChangeListener() {
                    @Override
                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

                    }
                });
            }

            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mDlWithoutWifiDialog);
                }
            });

            resId = forceUpdate ? R.string.lebian_quit_game : R.string.lebian_no_update;
            if (!forceUpdate) {
                builder.setNegativeButton(getString(resId), new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mDlWithoutWifiDialog);
                    }
                });
            }  else if (getGlobalBoolean(mContext, "ENABLE_EXIT_BUTTON", false)) {
                builder.setNegativeButton(getString(resId), new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mDlWithoutWifiDialog);
                    }
                });
            }
            createDialogCommon(builder,false);
            mDlWithoutWifiDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder) mDlWithoutWifiDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mDlWithoutWifiDialog, (Activity) mContext);
    }

    private void showUpdateWithoutWifiDialog(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        boolean dataConnection = params.getBoolean("dataConnection");
        boolean forceUpdate = params.getBoolean("forceUpdate");
        long rSize = params.getLong("size");
        NewCustomDialog.Builder builder;
        if (mUpdateWithoutWifiDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            builder.setMessage(String.format(getString(dataConnection ? R.string.lebian_dl_update_without_wifi : R.string.lebian_dl_update_wifi), ((float) (rSize)) / (1024.0f * 1024.0f)));

            builder.setTitle(getString(R.string.lebian_hint));
            if (!forceUpdate) {
                builder.setCheckBox(getString(R.string.lebian_next_no_prompt), false, new CompoundButton.OnCheckedChangeListener() {
                    @Override
                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    }
                });
            }
            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mUpdateWithoutWifiDialog);
                }
            });

            int resId = forceUpdate ? R.string.lebian_quit_game:R.string.lebian_no_update;
            if (!forceUpdate) {
                builder.setNegativeButton(getString(resId), new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mUpdateWithoutWifiDialog);
                    }
                });
            } else if (getGlobalBoolean(mContext, "ENABLE_EXIT_BUTTON", false)) {
                builder.setNegativeButton(getString(resId), new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mUpdateWithoutWifiDialog);
                    }
                });
            }
            createDialogCommon(builder,false);
            mUpdateWithoutWifiDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mUpdateWithoutWifiDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mUpdateWithoutWifiDialog, (Activity) mContext);
    }

    private void showUnfinishedDlDialog(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        NewCustomDialog.Builder builder;
        if (mUnfinishedDlDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            builder.setMessage(getString(R.string.lebian_dl_unfinished_dl_without_wifi));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mUnfinishedDlDialog);
                }
            });
            if (getGlobalBoolean(mContext, "ENABLE_EXIT_BUTTON", false)) {
                builder.setNegativeButton(getString(R.string.lebian_quit_game), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mUnfinishedDlDialog);
                    }
                });
            }
            createDialogCommon(builder,false);
            mUnfinishedDlDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mUnfinishedDlDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mUnfinishedDlDialog, (Activity) mContext);
    }

    private void showDlBackgroundWithoutWifiDialog(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        Log.d(TAG, "showDlBackgroundWithoutWifiDialog enter");
        NewCustomDialog.Builder builder;
        if (mDlBackgroundWithoutWifiDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            builder.setMessage(getString(R.string.lebian_dl_dl_without_wifi_background));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_dl_dl_background), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mDlBackgroundWithoutWifiDialog);
                }
            });
            if (getGlobalBoolean(mContext, "ENABLE_EXIT_BUTTON", false)) {
                builder.setNegativeButton(getString(R.string.lebian_quit_game), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mDlBackgroundWithoutWifiDialog);
                    }
                });
            }
            createDialogCommon(builder,false);
            mDlBackgroundWithoutWifiDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mDlBackgroundWithoutWifiDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mDlBackgroundWithoutWifiDialog, (Activity) mContext);
    }

    private void showSwitchGPDialog(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        NewCustomDialog.Builder builder;
        if (mSwitchGPDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setMessage(getString(R.string.lebian_dl_update_with_google_play));

            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mSwitchGPDialog);
                }
            });
            createDialogCommon(builder, false);
            mSwitchGPDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mSwitchGPDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mSwitchGPDialog, (Activity) mContext);
    }


    private AliveDialogLayer mPromptInstallDialog;
    private AliveDialogLayer mPromptUpdateDialog;
    private AliveDialogLayer mPromptDownloadedDialog;
    private AliveDialogLayer mPromptDownloadAllDialog;
    private AliveDialogLayer mPromptChooseBwbxDialog;
    private AliveDialogLayer mPromptMergeErrDialog;
    private AliveDialogLayer mPromptRestartDialog;
    private AliveDialogLayer mPromptChooseResDialog;
    private AliveDialogLayer mPromptNetworkUselessDialog;
    private AliveDialogLayer mPromptDLFromWebsDialog;
    private AliveDialogLayer mPromptSecIdErrDialog;
    private AliveDialogLayer mPromptTargetErrDialog;
    private AliveDialogLayer mPromptInvalidPackageDialog;

    private void showInstallDialog(int dialogType,Bundle params,DialogClickCallback clickCallback){
        boolean forceUpdate = params.getBoolean("forceUpdate");
        boolean haveInstallPermission = params.getBoolean("haveInstallPermission");
        NewCustomDialog.Builder builder;
        if (mPromptInstallDialog == null){
            builder = new NewCustomDialog.Builder(mContext);
            int resId = forceUpdate ? R.string.lebian_update_available_force_update_hint : R.string.lebian_update_available_update_hint;
            String message = getString(resId);
            if (Build.VERSION.SDK_INT >= 26) {//Build.VERSION_CODES.O = 26
                Log.d(TAG, "haveInstallPermission: ="+haveInstallPermission);
                if (!haveInstallPermission) {
                    if (mContext.getApplicationInfo().targetSdkVersion >= 26) {
                        resId = R.string.lebian_install_needs_uri_permission;
                        message += getString(resId);
                    } else {
                        resId = R.string.lebian_install_failed_needs_uri_permission;
                        message += getString(resId);
                    }
                }
            }
            builder.setMessage(message);
            builder.setTitle(getString(R.string.lebian_update_available));

            builder.setPositiveButton(getString(R.string.lebian_install_yes), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptInstallDialog);
                }
            });

            if (!forceUpdate || getGlobalBoolean(mContext, "ENABLE_EXIT_BUTTON", false)) {
                resId = forceUpdate ? R.string.lebian_quit_game : R.string.lebian_exit_dialog_no;
                builder.setNegativeButton(getString(resId), new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mPromptInstallDialog);
                    }
                });
            }
            createDialogCommon(builder, true);
            mPromptInstallDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptInstallDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptInstallDialog, (Activity) mContext);
    }


    private void showDownloadedDialog(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        NewCustomDialog.Builder builder;
        if (mPromptDownloadedDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            builder.setMessage(getString(R.string.lebian_downloaded_message_body));
            builder.setTitle(getString(R.string.lebian_hint));

            builder.setPositiveButton(getString(R.string.lebian_downloaded_current), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptDownloadedDialog);
                }
            });

            builder.setNegativeButton(getString(R.string.lebian_downloaded_next), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptDownloadedDialog);
                }
            });
            createDialogCommon(builder, true);
            mPromptDownloadedDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptDownloadedDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptDownloadedDialog, (Activity) mContext);
    }

    private void showUpdateDialog(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        NewCustomDialog.Builder builder;
        if (mPromptUpdateDialog == null) {
            boolean isUseGooglePlayUpdate = params.getBoolean("isUseGooglePlayUpdate");
            boolean forceUpdate = params.getBoolean("forceUpdate");
            boolean dataConnection = params.getBoolean("dataConnection");
            long size = params.getLong("size");

            builder = new NewCustomDialog.Builder(mContext);

            int resId = R.string.lebian_dl_update_without_wifi;
            int resId2 = R.string.lebian_dl_update_wifi;

            if(isUseGooglePlayUpdate) {
                builder.setMessage(getString(R.string.lebian_dl_update_with_google_play));
            }else {
                builder.setMessage(String.format(getString(dataConnection ? resId : resId2), ((float) (size)) / (1024.0f * 1024.0f)));
            }
            builder.setTitle(getString(R.string.lebian_hint));
            if (!forceUpdate) {
                builder.setCheckBox(getString(R.string.lebian_next_no_prompt), false, new CompoundButton.OnCheckedChangeListener() {
                    @Override
                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    }
                });
            }
            resId = R.string.lebian_button_ok;
            resId2 = R.string.lebian_dl_dl_background;
            builder.setPositiveButton(getString(forceUpdate ? resId : resId2), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptUpdateDialog);
                }
            });

            if (!forceUpdate) {
                builder.setNegativeButton(getString(R.string.lebian_no_update), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mPromptUpdateDialog);
                    }
                });
            } else if (getGlobalBoolean(mContext, "ENABLE_EXIT_BUTTON", false)) {
                builder.setNegativeButton(getString(R.string.lebian_quit_game), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mPromptUpdateDialog);
                    }
                });
            }
            createDialogCommon(builder,true);
            mPromptUpdateDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptUpdateDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptUpdateDialog, (Activity) mContext);
    }

    private void showDownloadAll(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        long size = params.getLong("size");
        boolean dataConnection = params.getBoolean("dataConnection");
        int behavior = params.getInt("behavior");

        NewCustomDialog.Builder builder;
        if (mPromptDownloadAllDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            int resId = R.string.lebian_first_dialog_note;
            int resId1 = R.string.lebian_first_dialog_note_al;
            builder.setMessage(String.format(getString(dataConnection ? resId : resId1), ((float) (size)) / (1024.0f * 1024.0f)));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_dl_dl_background), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptDownloadAllDialog);
                }
            });
            if (behavior != TestUnit.BEHAVIOR_B1_FIRST_DIALOG_BG_DOWNLOAD_ONE_BUTTON) {
                resId = behavior == TestUnit.BEHAVIOR_D1_FIRST_DIALOG_BG_DOWNLOAD_CANCEL_BUTTON?R.string.lebian_button_cancel:R.string.lebian_download_later;
                builder.setNegativeButton(getString(resId), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mPromptDownloadAllDialog);
                    }
                });
            }
            createDialogCommon(builder,false);
            mPromptDownloadAllDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptDownloadAllDialog.getDialogBuilder();
        }

        builder.setDialogType(dialogType);
        builder.setClickCallback(clickCallback);
        show(mPromptDownloadAllDialog, (Activity) mContext);
    }

    private void showChooseBwbx(int dialogType,Bundle params,DialogClickCallback clickCallback, Activity topActivity) {
        if (null == topActivity) {
            topActivity = (Activity) mContext;
        }
        long size = params.getLong("size");
        int zipType = params.getInt("zipType");
        boolean lbresLater = params.getBoolean("lbresLater");
        NewCustomDialog.Builder builder;
        if (mPromptChooseBwbxDialog == null) {
            builder = new NewCustomDialog.Builder(topActivity);
            int resId = R.string.lebian_choose_by_user_bwbx;
            if (zipType == 2)
                resId = R.string.lebian_choose_by_user_twice_load;
            builder.setMessage(String.format(getString(resId), ((float) (size)) / (1024.0f * 1024.0f)));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_download_now), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptChooseBwbxDialog);
                }
            });

            if (!getGlobalBoolean(topActivity, "CHOOSE_BY_USER_BWBX_FORCE", false)) {
                resId = lbresLater ? R.string.lebian_continue_game : R.string.lebian_quit_game;
                if (lbresLater) {
                    builder.setNegativeButton(getString(resId), new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dismiss(mPromptChooseBwbxDialog);
                        }
                    });
                } else if (getGlobalBoolean(topActivity, "ENABLE_EXIT_BUTTON", false)) {
                    builder.setNegativeButton(getString(resId), new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dismiss(mPromptChooseBwbxDialog);
                        }
                    });
                }
            }
            createDialogCommon(builder,false);
            mPromptChooseBwbxDialog = new AliveDialogLayer(topActivity, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptChooseBwbxDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptChooseBwbxDialog, topActivity);
    }

    //mergeErrType 1 is permissionError, 2 is provider error
    private void showMergeErrDialog(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        int mergeErrType = params.getInt("mergeErrType");
        String errContent = params.getString("errContent");
        String correctContent = params.getString("correctContent");
        int mainChId = params.getInt("mainChId");
        NewCustomDialog.Builder builder;
        if (mPromptMergeErrDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            int resId = -1;
            if (mergeErrType == 0) {
                if (TextUtils.isEmpty(errContent)){
                    return;
                }
                builder.setMessage(errContent);
            } else {
                if (mergeErrType == 1)
                    resId = R.string.lebian_permiss_missing;
                else if (mergeErrType == 2) {
                    resId = R.string.lebian_authorities_error_new;
                }
                else if (mergeErrType == 3)
                    resId = R.string.lebian_lebian_flag_missing;
                else if (mergeErrType == 4)
                    resId = R.string.lebian_main_chid_err;
                else if (mergeErrType == 5)
                    resId = R.string.lebian_switch_err;
                else if (mergeErrType == 6)
                    resId = R.string.lebian_jar_version_not_match_err;
                if (mergeErrType == 1 || mergeErrType == 3) {
                    builder.setMessage(getString(resId) + errContent);
                } else if (mergeErrType == 4)
                    builder.setMessage(String.format(getString(resId), errContent, mainChId));
                else if (mergeErrType == 5)
                    builder.setMessage(getString(resId));
                else if (mergeErrType == 2) {
                    String errMessage = getString(resId);
                    builder.setMessage(String.format(errMessage, errContent, correctContent));
                } else if (mergeErrType == 6) {
                    builder.setMessage(errContent + getString(resId));
                }
            }
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptMergeErrDialog);
                }
            });
            createDialogCommon(builder, true);
            mPromptMergeErrDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptMergeErrDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptMergeErrDialog, (Activity) mContext);
    }

    private void showRestartDialogForJJ(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        NewCustomDialog.Builder builder;
        if (mPromptRestartDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            builder.setMessage(getString(R.string.lebian_for_jj_restart));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptRestartDialog);
                }
            });
            createDialogCommon(builder,true);
            mPromptRestartDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptRestartDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptRestartDialog, (Activity) mContext);
    }

    private void showChooseResPatch(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        long size = params.getLong("size");
        boolean dataConnection = params.getBoolean("dataConnection");
        boolean forceDl = params.getBoolean("forceDl");
        NewCustomDialog.Builder builder;
        if (mPromptChooseResDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            int resId = dataConnection ? R.string.lebian_download_patch_res_without_wifi : R.string.lebian_download_patch_res;
            builder.setMessage(String.format(getString(resId), ((float) (size)) / (1024.0f * 1024.0f)));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_download_now), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptChooseResDialog);
                }
            });

            resId = forceDl ? R.string.lebian_quit_game : R.string.lebian_continue_game;
            if (!forceDl) {
                builder.setNegativeButton(getString(resId), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mPromptChooseResDialog);
                    }
                });
            } else if (getGlobalBoolean(mContext, "ENABLE_EXIT_BUTTON", false)) {
                builder.setNegativeButton(getString(resId), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mPromptChooseResDialog);
                    }
                });
            }
            createDialogCommon(builder,false);
            mPromptChooseResDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptChooseResDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptChooseResDialog, (Activity) mContext);
    }

    private void showLoadingDialog(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        if (mContext instanceof Activity) {
            Dialog loadDialog = new Dialog(mContext);
            //获取背景图
            int backgroundImageId = getBackgroundImageId(mContext);
            if (backgroundImageId > 0) {
                Bitmap bitmap = BitmapFactory.decodeResource(mContext.getResources(), backgroundImageId);
                if (bitmap != null) {
                    LbUiWindowManager lbUiWindowManager = LbUiWindowManager.getInstance(mContext);
                    int screenWidth = lbUiWindowManager.getScreenWidth();
                    int screenHeight = lbUiWindowManager.getScreenHeight();
                    //剪裁背景图
                    bitmap = BitmapUtils.picture(mContext, bitmap, screenWidth, screenHeight);
                    Drawable drawable = new BitmapDrawable(bitmap);
                    ((Activity) mContext).getWindow().setBackgroundDrawable(drawable);
                }
            }
            LayoutInflater inflater = LayoutInflater.from(mContext);
            View view = inflater.inflate(R.layout.lebian_progress_dialog, null, false);
            TextView tips = view.findViewById(R.id.lebian_text_progress_loading);
            tips.setText(getString(R.string.lebian_loading_pls_wait));
            loadDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
            loadDialog.getWindow().setBackgroundDrawableResource(android.R.color.transparent);
            loadDialog.setContentView(view);
            loadDialog.setCancelable(false);
            loadDialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
                @Override
                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    return keyCode == KeyEvent.KEYCODE_SEARCH;
                }
            });
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                loadDialog.getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
            }
            loadDialog.show();
        }
    }

    public void showNotNetworkDialog(int dialogType,Bundle params,DialogClickCallback clickCallback){
        NewCustomDialog.Builder builder;
        if (mPromptNetworkUselessDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            builder.setTitle(getString(R.string.lebian_network_error));
            builder.setMessage(getString(R.string.lebian_enable_internet_access));
            builder.setPositiveButton(getString(R.string.lebian_enable_now), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptNetworkUselessDialog);
                }
            });
            createDialogCommon(builder,true);
            mPromptNetworkUselessDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptNetworkUselessDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptNetworkUselessDialog, (Activity) mContext);
    }


    public void showDloadFromWebsite(int dialogType,Bundle params,DialogClickCallback clickCallback){
        NewCustomDialog.Builder builder;
        if (mPromptDLFromWebsDialog == null) {
            boolean forceUpdate = params.getBoolean("forceUpdate");
            builder = new NewCustomDialog.Builder(mContext);
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setMessage(getString(R.string.lebian_new_version_available));
            builder.setPositiveButton(getString(R.string.lebian_website_download), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptDLFromWebsDialog);
                }
            });
            if (forceUpdate && getGlobalBoolean(mContext, "ENABLE_EXIT_BUTTON", false)) {
                builder.setNegativeButton(getString(R.string.lebian_quit_game), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mPromptDLFromWebsDialog);
                    }
                });
            }else{
                builder.setNegativeButton(getString(R.string.lebian_continue_game), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mPromptDLFromWebsDialog);
                    }
                });
            }
            createDialogCommon(builder,true);
            mPromptDLFromWebsDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder) mPromptDLFromWebsDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptDLFromWebsDialog, (Activity) mContext);
    }

    private void showSecIdErrDialog(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        String errMsg = params.getString("errMsg");
        NewCustomDialog.Builder builder;
        if (mPromptSecIdErrDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            String msgBody = String.format(getString(R.string.lebian_secid_err), errMsg == null ? "LEBIAN_SECID" : errMsg);
            builder.setMessage(msgBody);
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptSecIdErrDialog);
                }
            });
            createDialogCommon(builder,true);
            mPromptSecIdErrDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptSecIdErrDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptSecIdErrDialog, (Activity) mContext);
    }

    private void showTargetSdkVersionErrDialog(int dialogType,Bundle params,DialogClickCallback clickCallback) {
        NewCustomDialog.Builder builder;
        if (mPromptTargetErrDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            builder.setMessage(getString(R.string.lebian_target_sdk_version_err));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptTargetErrDialog);
                }
            });
            createDialogCommon(builder,true);
            mPromptTargetErrDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptTargetErrDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptTargetErrDialog, (Activity) mContext);
    }

    private void showInvalidPackageDialog(int dialogType,Bundle params,DialogClickCallback clickCallback){
        NewCustomDialog.Builder builder;
        if (mPromptInvalidPackageDialog == null) {
            builder = new NewCustomDialog.Builder(mContext);
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setMessage(getString(R.string.lebian_invalid_package));

            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mPromptInvalidPackageDialog);
                }
            });
            createDialogCommon(builder,true);
            mPromptInvalidPackageDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mPromptInvalidPackageDialog.getDialogBuilder();
        }
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        show(mPromptInvalidPackageDialog, (Activity) mContext);
    }


    private String lebian_err_loadres_generic;
    private String lebian_err_loadres_network;
    private String lebian_err_loadres_timeout;
    private String lebian_err_loadres_outofspace;
    private String lebian_err_loadres_md5_mis;
    private String lebian_err_loadres_rename_fail;
    private String lebian_download_all_note;
    private String lebian_download_all_note_al;
    private String lebian_download_all_note_interface;
    private String lebian_remaining_res_downloading;
    private String lebian_choose_by_user_bwbx;
    private String lebian_network_environment_poor;
    private String lebian_download_all_note_switch_gnet;


    private void showGameDialog(int dialogType, boolean show, Activity activity, Bundle params, final DialogClickCallback clickCallback) {
        NewCustomDialog.Builder builder;
        if (mBwbxErrorDialog == null || !show) {
            if (activity == null) {
                Log.d(TAG, "showGameDialog no topActivity");
                return;
            }
            lebian_err_loadres_generic = getString(R.string.lebian_err_loadres_generic);
            lebian_err_loadres_network = getString(R.string.lebian_err_loadres_network);
            lebian_err_loadres_timeout = getString(R.string.lebian_err_loadres_timeout);
            lebian_err_loadres_outofspace = getString(R.string.lebian_err_loadres_outofspace);
            lebian_err_loadres_md5_mis = getString(R.string.lebian_err_loadres_md5_mis);
            lebian_err_loadres_rename_fail = getString(R.string.lebian_err_loadres_rename_fail);

            builder = new NewCustomDialog.Builder(mContext, activity);
            builder.setMessage(getString(R.string.lebian_err_loadres_generic));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setParams(params);
            builder.setPositiveButton(getString(R.string.lebian_retry), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mBwbxErrorDialog);
                }
            });

            if (getGlobalBoolean(mContext, "ENABLE_EXIT_BUTTON", false)) {
                builder.setNegativeButton(getString(R.string.lebian_quit_game), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mBwbxErrorDialog);
                    }
                });
            }
            createDialogCommon(builder,false);
            mBwbxErrorDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mBwbxErrorDialog.getDialogBuilder();
        }
        long errcode = params.getLong("errcode");
        String exception = params.getString("exceptionInfo");
        String desc = lebian_err_loadres_generic;
        if (errcode == ERR_NETWORK) {
            desc = lebian_err_loadres_network;
        } else if (errcode == ERR_SPACE_NOT_ENOUGH) {
            desc = lebian_err_loadres_outofspace;
        } else if (errcode == ERR_TIMEOUT) {
            desc = lebian_err_loadres_timeout;
        } else if (errcode == ERR_MD5_MIS) {
            desc = lebian_err_loadres_md5_mis;
        } else if (errcode == ERR_RENAME_FAIL) {
            desc = lebian_err_loadres_rename_fail;
        }
        String msg = (errcode == -1 && exception != null && exception.length() > 0) ? (desc + "(" + exception + ")") : desc;
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        builder.setMessage(msg);
        show(mBwbxErrorDialog, PopupGuard.PRIORITY_SEASONABLE, activity);
    }

    private void showProgressDialog(int dialogType, boolean show, Activity activity, Bundle params, final DialogClickCallback clickCallback) {
        int progress = null != params ? params.getInt("progress", -1) : -1;
        boolean showBecauseOfProgress = null != params && params.containsKey("progress");
        showBecauseOfProgress = showBecauseOfProgress && 0 <= progress && progress <= 100;

        // progress 和 show 参数都要求不展示时, 才隐藏loading.
        // 也可以理解成 show 展示loading, progress[0-100] 展示loading且有进度
        if (!showBecauseOfProgress && !show) {
            if (null != mProgressDialog) {
                dismiss(mProgressDialog);
            }
            return;
        }

        LoadingDialog.Builder builder;
        if (mProgressDialog == null) {
            builder = new LoadingDialog.Builder(mContext);
            mProgressDialog = new AliveDialogLayer(mContext, builder);
            builder.setProgress(getString(R.string.lebian_progress_loading));
            builder.setCanceledOnTouchOutside(false);
            builder.setOnKeyListener(new DialogInterface.OnKeyListener() {
                @Override
                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    switch (keyCode) {
                        case KeyEvent.KEYCODE_BACK:
                        case KeyEvent.KEYCODE_SEARCH: {
                            return true;
                        }
                        default:
                            return false;
                    }
                }
            });
        } else {
            builder = (LoadingDialog.Builder)mProgressDialog.getDialogBuilder();
        }

        boolean isShowProgress = null != params && params.containsKey("progress");
        if (!isShowProgress) {
            show(mProgressDialog, PopupGuard.PRIORITY_INFO, activity);
            return;
        } else {
            String loading = getResources(mContext).getString(R.string.lebian_progress_loading);
            builder.setProgress(String.format("%s%d%%", loading, progress));
            show(mProgressDialog, PopupGuard.PRIORITY_INFO, activity);
        }
    }

    private void showWifiToMobile(int dialogType, boolean show, Activity activity, Bundle params, final DialogClickCallback clickCallback) {
        Log.d(TAG, "showDownloadAll ENTER");
        long size = params.getLong("size");
        NewCustomDialog.Builder builder;
        if (mWifiToMobileDialog == null || !show) {
            builder = new NewCustomDialog.Builder(mContext, activity);
            lebian_download_all_note_switch_gnet = getString(R.string.lebian_download_all_note_switch_gnet);
            builder.setMessage(String.format(lebian_download_all_note_switch_gnet,((float)(size))/(1024.0f * 1024.0f)));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_continue_game), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mWifiToMobileDialog);
                }
            });

            builder.setNegativeButton(getString(R.string.lebian_download_not_now), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mWifiToMobileDialog);
                }
            });
            createDialogCommon(builder,false);
            mWifiToMobileDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mWifiToMobileDialog.getDialogBuilder();
        }

        String msg = String.format(lebian_download_all_note_switch_gnet, ((float) (size)) / (1024.0f * 1024.0f));
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        builder.setMessage(msg);
        show(mWifiToMobileDialog, activity);
    }

    private void showDownloadAllLater(int dialogType, boolean show, Activity activity, Bundle params, final DialogClickCallback clickCallback) {
        long size = params.getLong("size");
        boolean dataConnection = params.getBoolean("dataConnection");
        NewCustomDialog.Builder builder;
        if (mBwbxSecondDialog == null || !show) {
            builder = new NewCustomDialog.Builder(mContext, activity);
            lebian_download_all_note = getString(R.string.lebian_download_all_note);
            lebian_download_all_note_al = getString(R.string.lebian_download_all_note_al);
            builder.setMessage(String.format(lebian_download_all_note,((float)(size))/(1024.0f * 1024.0f)));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_download_while_play), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mBwbxSecondDialog);
                }
            });

            if (getGlobalBoolean(mContext, "ENABLE_EXIT_BUTTON", false)) {
                builder.setNegativeButton(getString(R.string.lebian_quit_game), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mBwbxSecondDialog);
                    }
                });
            }
            createDialogCommon(builder,false);
            mBwbxSecondDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mBwbxSecondDialog.getDialogBuilder();
        }

        String msg = String.format(dataConnection ? lebian_download_all_note : lebian_download_all_note_al, ((float) (size)) / (1024.0f * 1024.0f));
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        builder.setMessage(msg);
        show(mBwbxSecondDialog, activity);
    }

    private void showDownloadAllLaterInterface(int dialogType, boolean show, Activity activity, Bundle params, final DialogClickCallback clickCallback) {
        long size = params.getLong("size");
        NewCustomDialog.Builder builder;
        if (mDownloadAllLaterInterface == null || !show) {
            builder = new NewCustomDialog.Builder(mContext, activity);
            lebian_download_all_note_interface = getString(R.string.lebian_download_all_note_interface);
            builder.setMessage(String.format(lebian_download_all_note_interface,((float)(size))/(1024.0f * 1024.0f)));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mDownloadAllLaterInterface);
                }
            });
            builder.setNegativeButton(getString(R.string.lebian_button_cancel), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mDownloadAllLaterInterface);
                }
            });
            createDialogCommon(builder,false);
            mDownloadAllLaterInterface = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mDownloadAllLaterInterface.getDialogBuilder();
        }
        String msg = String.format(lebian_download_all_note_interface, ((float) (size)) / (1024.0f * 1024.0f));
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        builder.setMessage(msg);
        show(mDownloadAllLaterInterface, activity);
    }

    private void showRemainingResDownloading(int dialogType, boolean show, Activity activity, Bundle params, final DialogClickCallback clickCallback) {
        long size = params.getLong("size");
        NewCustomDialog.Builder builder;
        if (mRemainingResDowning == null || !show) {
            builder = new NewCustomDialog.Builder(mContext, activity);
            lebian_remaining_res_downloading = getString(R.string.lebian_remaining_res_downloading);
            builder.setMessage(String.format(lebian_remaining_res_downloading,((float)(size))/(1024.0f * 1024.0f)));
            builder.setTitle(getString(R.string.lebian_hint));
            builder.setPositiveButton(getString(R.string.lebian_button_ok), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mRemainingResDowning);
                }
            });
            createDialogCommon(builder,false);
            mRemainingResDowning = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mRemainingResDowning.getDialogBuilder();
        }
        String msg = String.format(lebian_remaining_res_downloading, ((float) (size)) / (1024.0f * 1024.0f));
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        builder.setMessage(msg);
        show(mRemainingResDowning, activity);
    }

    private void showDownloadFullRes(int dialogType, boolean show, Activity activity, Bundle params, final DialogClickCallback clickCallback) {
        long size = params.getLong("size");
        int triggerReason = params.getInt("triggerReason");
        boolean oneBtn = params.getBoolean("oneBtn");
        NewCustomDialog.Builder builder;
        if (mDownloadFullResDialog == null || !show) {
            builder = new NewCustomDialog.Builder(mContext, activity);
            int resId = triggerReason != 1 ? R.string.lebian_choose_by_user_bwbx : R.string.lebian_network_environment_poor;
            lebian_choose_by_user_bwbx = getString(R.string.lebian_choose_by_user_bwbx);
            lebian_network_environment_poor = getString(R.string.lebian_network_environment_poor);
            builder.setMessage(String.format(getString(resId),((float)(size))/(1024.0f * 1024.0f)));
            builder.setTitle(getString(R.string.lebian_hint));
            if(!getGlobalBoolean(mContext, "SHOW_DIALOG_BUTTON_BY_OLD_USER", false)){
                resId = R.string.lebian_exit_dialog_yes;
            }else{
                resId = R.string.lebian_download_now;
            }
            builder.setPositiveButton(getString(resId), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dismiss(mDownloadFullResDialog);
                }
            });
            if(!oneBtn&&!getGlobalBoolean(mContext, "SHOW_DIALOG_BUTTON_BY_OLD_USER", false)){
                builder.setNegativeButton(getString(R.string.lebian_exit_dialog_no), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mDownloadFullResDialog);
                    }
                });
            }else if (getGlobalBoolean(mContext, "ENABLE_EXIT_BUTTON", false)) {
                builder.setNegativeButton(getString(R.string.lebian_quit_game), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dismiss(mDownloadFullResDialog);
                    }
                });
            }
            createDialogCommon(builder,false);
            mDownloadFullResDialog = new AliveDialogLayer(mContext, builder);
        } else {
            builder = (NewCustomDialog.Builder)mDownloadFullResDialog.getDialogBuilder();
        }
        String msg = String.format(triggerReason != 1 ? lebian_choose_by_user_bwbx : lebian_network_environment_poor, ((float) (size)) / (1024.0f * 1024.0f));
        builder.setDialogType(dialogType);
        builder.setParams(params);
        builder.setClickCallback(clickCallback);
        builder.setMessage(msg);
        show(mDownloadFullResDialog, activity);
    }

    private int getBackgroundImageId(Context context) {
        Resources mainRes = getResources(context);
        Resources apkRes = getApkResources(context);
        //获取名字为lebian_main_background_normal的背景图
        int backgroundId = apkRes.getIdentifier(SwitchView.BG_NAME, "drawable", context.getPackageName());
        if (backgroundId <= 0) {
            backgroundId = mainRes.getIdentifier(SwitchView.BG_NAME, "drawable", context.getPackageName());
        }
        //名字为lebian_main_background_normal的背景图不存在
        //寻找lebian_main_background_normal_x的背景图，x最大为9;
        if (backgroundId <= 0) {
            for (int i = 0; i < 10; i++) {
                backgroundId = apkRes.getIdentifier(SwitchView.BG_NAME + "_" + i, "drawable", context.getPackageName());
                //找到一张就退出循环
                if (backgroundId > 0) {
                    break;
                } else {
                    backgroundId = mainRes.getIdentifier(SwitchView.BG_NAME + "_" + i, "drawable", context.getPackageName());
                    //找到一张就退出循环
                    if (backgroundId > 0) {
                        break;
                    }
                }
            }
        }
        return backgroundId;
    }

    private void createDialogCommon(NewCustomDialog.Builder dialog,boolean nav) {
        if (dialog != null) {
            dialog.setCancelable(false);
            dialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
                @Override
                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    return keyCode == KeyEvent.KEYCODE_SEARCH;
                }
            });
            dialog.setNav(nav);
            dialog.setCustomClickCallback(mCustomClickCallback);
        }
    }

    /**
     * 隐藏或者关闭指定对话框
     * @param dialog AliveDialogLayer 实例
     */
    private void dismiss(AliveDialogLayer dialog) {
        popupGuard.dismiss(dialog);
    }

    /**
     * 展示指定的对话框
     * @param dialog AliveDialogLayer 实例
     * @param activity 对话框悬浮的activity
     */
    private void show(AliveDialogLayer dialog, Activity activity) {
        show(dialog, PopupGuard.PRIORITY_CONFIRM, activity);
    }

    /**
     * 以指定级别弹出指定的对话框
     * @param dialog AliveDialogLayer 实例
     * @param priority 对话框级别. {@link PopupGuard } PRIORITY 开头常量
     * @param activity 对话框悬浮的activity
     */
    private void show(AliveDialogLayer dialog, int priority, Activity activity) {
        popupGuard.show(dialog, priority, activity);
    }
}

