package com.excelliance.open;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.drawable.AnimationDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.excelliance.open.library.DialogClickCallback;
import com.excelliance.open.library.ErrorCode;
import com.excelliance.open.library.LBDnsListener;
import com.excelliance.lbui.R;
import com.excelliance.open.custom.CustomNextChapterCallback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NextChapterNew extends BaseActivity implements LBDnsListener {
    private final static String TAG = "NextChapter";

    private LBSwitchView mSwitchView;
    private TextView mTextStatusView;
    private TextView mTextProgressView;
    private AdaptiveProgressBar mAdaptiveProgressBar;
    private ImageView mFrameAnimationView;
    private TextView mResStatusView;
    private TextView mDownloadSpeedView;
    private Handler mHandler;
    private String mStrDownloadStatus;
    private NextChapterHelper mNextChapterHelper;
    private UIDialogManager mUIDialogManager;
    private CustomNextChapterCallback mCallback;

    private static final int REQUEST_CODE_PERMISSIONS = 101;

    // 根据 Android 版本确定所需权限
    private String[] getRequiredPermissions() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            // Android 13+ 使用媒体权限
            return new String[]{
                    Manifest.permission.READ_MEDIA_IMAGES,
                    Manifest.permission.READ_MEDIA_VIDEO,
                    Manifest.permission.READ_MEDIA_AUDIO
            };
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            // Android 10-12 只需要读权限
            return new String[]{Manifest.permission.READ_EXTERNAL_STORAGE};
        } else {
            // Android 9 及以下需要读写权限
            return new String[]{
                    Manifest.permission.READ_EXTERNAL_STORAGE,
                    Manifest.permission.WRITE_EXTERNAL_STORAGE
            };
        }
    }

    // 检查是否已有权限
    private boolean hasRequiredPermissions() {
        String[] requiredPermissions = getRequiredPermissions();
        for (String permission : requiredPermissions) {
            if (!hasPermission(this, permission)) {
                return false;
            }
        }
        return true;
    }

    private boolean hasPermission(Context context, String permission) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            return context.checkSelfPermission(permission) == PackageManager.PERMISSION_GRANTED;
        } else {
            // 对于 API < 23 的设备，安装时即授予权限
            return true;
        }
    }

    // 请求存储权限
    private void requestStoragePermissions() {
        // 检查是否已有权限
        if (hasRequiredPermissions()) {
            return;
        }

        // 获取需要请求的权限列表
        List<String> permissionsToRequest = new ArrayList<>();
        for (String permission : getRequiredPermissions()) {
            if (!hasPermission(this, permission)) {
                permissionsToRequest.add(permission);
            }
        }

        if (permissionsToRequest.isEmpty()) {
            return;
        }
        String[] permissions = permissionsToRequest.toArray(new String[0]);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            // 对于 API 23+ 的设备，使用系统权限请求
            super.requestPermissions(permissions, REQUEST_CODE_PERMISSIONS);
        } else {
            // 对于 API < 23 的设备，直接授予权限
            handlePreMarshmallowPermissions(REQUEST_CODE_PERMISSIONS, permissions);
        }
    }

    // 处理旧版本设备权限
    private void handlePreMarshmallowPermissions(int requestCode, String[] permissions) {
        // 对于 API < 23 的设备，所有权限在安装时即被授予
        int[] grantResults = new int[permissions.length];
        Arrays.fill(grantResults, PackageManager.PERMISSION_GRANTED);

        // 触发权限回调
        onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String[] permissions,
                                           int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public int getLBTheme() {
        return R.style.LebianNextChapterTheme;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        mNextChapterHelper = new NextChapterHelper(this);
        mNextChapterHelper.windowConfigs();
        super.onCreate(savedInstanceState);
        mHandler = new Handler();
        mNextChapterHelper.init(mHandler, getIntent(), this);
        mUIDialogManager = new UIDialogManager(this);
        setContentView(R.layout.lebian_next_chapter_new);
        mSwitchView = findViewById(R.id.background_view);
        mTextStatusView = findViewById(R.id.lebian_text_status);
        mTextProgressView = findViewById(R.id.lebian_text_progress);
        mAdaptiveProgressBar = findViewById(R.id.lebian_progressBar);
        mFrameAnimationView = findViewById(R.id.lebian_framen_animation);
        mResStatusView = findViewById(R.id.lebian_resource_status);
        mDownloadSpeedView = findViewById(R.id.lebian_download_speed);
        mNextChapterHelper.onCreate(savedInstanceState);
        prepareDownloadStatus();
//        dotPlayLoop();
        startAnimation();
        mAdaptiveProgressBar.setOnProgressChangeListener(mOnProgressChangeListener);
        mNextChapterHelper.prepareViewFinished();
        new ProgressSimulator(mNextChapterHelper.isTestMode(), this).progressSimulate();
        requestStoragePermissions();
        mCallback = new CustomNextChapterCallback();
    }


    AdaptiveProgressBar.OnProgressChangeListener mOnProgressChangeListener = new AdaptiveProgressBar.OnProgressChangeListener() {
        @Override
        public void onProgressChanged(int progress) {
            updateImagePosition(progress);
        }
    };

    private void updateImagePosition(int progress){
        // 确保视图已完成布局
        if (mAdaptiveProgressBar.getWidth() <= 0 || mFrameAnimationView.getWidth() <= 0)
            return;

        if(progress < 60){
            return;
        }
        // 计算当前进度对应的位置
        float ratio = (float) progress / mAdaptiveProgressBar.getMax();
        int progressPosition = (int) (ratio * mAdaptiveProgressBar.getWidth());
        RelativeLayout.LayoutParams imageParams = (RelativeLayout.LayoutParams) mFrameAnimationView.getLayoutParams();
        imageParams.leftMargin = progressPosition - mFrameAnimationView.getWidth() + 41;

        Log.i(TAG,  "ProgressBar width=" + mAdaptiveProgressBar.getWidth() + " ProgressBarLeft="+ mAdaptiveProgressBar.getLeft() +" progressPosition=" + progressPosition + " imageParams.leftMargin=" + imageParams.leftMargin + " ImageWidth=" + mFrameAnimationView.getWidth());

        mFrameAnimationView.setLayoutParams(imageParams);
    }

    private void resetImagePosition(){
        RelativeLayout.LayoutParams imageParams = (RelativeLayout.LayoutParams) mFrameAnimationView.getLayoutParams();
        imageParams.leftMargin = 0;
        mFrameAnimationView.setLayoutParams(imageParams);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        mNextChapterHelper.onConfigurationChanged(newConfig);
    }

    @Override
    protected void onResume() {
        super.onResume();
        mNextChapterHelper.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
        mNextChapterHelper.onPause();
    }

    @Override
    protected void onStop() {
        super.onStop();
        mNextChapterHelper.onStop();
        mSwitchView.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mNextChapterHelper.onDestroy();
        mSwitchView.onDestroy();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (mNextChapterHelper.isUIMode()) {
            return mNextChapterHelper.onKeyDown(keyCode, event);
        } else {
            return super.onKeyDown(keyCode, event);
        }
    }

    private void prepareDownloadStatus() {
        mStrDownloadStatus = getString(R.string.lebian_dl_status_connecting);
    }

    private void dotPlayLoop() {
        Runnable runnable = new DotRunnable();
        mHandler.post(runnable);
    }

    private void startAnimation(){
        ((AnimationDrawable)(mFrameAnimationView.getBackground())).start();
    }

    public class DotRunnable implements Runnable {
        public static final int TIME = 4;
        private int mCount = 0;

        @Override
        public void run() {
            StringBuilder stringBuffer = new StringBuilder(mStrDownloadStatus);
            mCount = mCount % TIME;
            for (int i = 0; i < mCount; i++) {
                stringBuffer.append(".");
            }
            mTextStatusView.setText(stringBuffer.toString());
            mCount++;
            mHandler.postDelayed(this, 800);
        }
    }

    @Override
    public void onDownloadStart(int resType, String numerator) {
        mTextStatusView.setVisibility(View.VISIBLE);
        mFrameAnimationView.setVisibility(View.VISIBLE);
        mTextProgressView.setVisibility(View.VISIBLE);
        mAdaptiveProgressBar.setVisibility(View.VISIBLE);
        mDownloadSpeedView.setVisibility(View.GONE);
        mStrDownloadStatus = getResources().getString(resType == 1 ? R.string.lebian_dl_status_updating : R.string.lebian_dl_status_downloading);
        mTextStatusView.setText(mStrDownloadStatus);
//        if (numerator != null) {
//            mResStatusView.setVisibility(View.VISIBLE);
//            mResStatusView.setText(numerator);
//        } else {
        mResStatusView.setVisibility(View.VISIBLE);
        mResStatusView.setText(String.format("%.2f", mAdaptiveProgressBar.getProgress()/10.0).toString() + "%");
//        }
        mCallback.onDownloadStart(resType, numerator);
    }

    @Override
    public void onDownloadProgress(int resType, int progress) {
        mAdaptiveProgressBar.setProgress(progress*10);
        if (progress < 5) {
            mAdaptiveProgressBar.setProgress(5*10);
        }
        mResStatusView.setVisibility(View.VISIBLE);
        mResStatusView.setText(String.format("%.2f", mAdaptiveProgressBar.getProgress()/10.0f).toString() + "%");
        mCallback.onDownloadProgress(resType, progress);
    }

    @Override
    public void onDownloadSize(long downloaded, long total) {
        mTextProgressView.setText("[" + String.format("%.2fMB/%.2fMB", ((float) (downloaded)) / (1024.0f * 1024.0f), ((float) (total)) / (1024.0f * 1024.0f)) + "]");
        mCallback.onDownloadSize(downloaded, total);
    }

    @Override
    public void onDownloadSpeed(float speed) {
        String strSpeed = speed + "KB/s";
        if (speed >= 1024) {
            strSpeed = String.format("%.2fMB/s", speed / 1024.0f);
        }
        mDownloadSpeedView.setText(strSpeed);
        mCallback.onDownloadSpeed(speed);
    }

    @Override
    public void onDownloadFinish(int resType) {
//        if(resType == 1){
            mResStatusView.setText("100.00%");
//        }
        mCallback.onDownloadFinish(resType);
    }

    @Override
    public void onExtractStart(int resType, String numerator) {
        mTextStatusView.setVisibility(View.VISIBLE);
        mFrameAnimationView.setVisibility(View.VISIBLE);
        mTextProgressView.setText("");
        mAdaptiveProgressBar.setVisibility(View.VISIBLE);
        mDownloadSpeedView.setVisibility(View.GONE);
        mResStatusView.setText("");
        mAdaptiveProgressBar.setProgress(0);
        mStrDownloadStatus = getResources().getString(R.string.lebian_dl_status_extract);
        mTextStatusView.setText(mStrDownloadStatus);
//        if (numerator != null) {
//            mResStatusView.setVisibility(View.VISIBLE);
//            mResStatusView.setText(numerator);
//        } else {
//            mResStatusView.setVisibility(View.INVISIBLE);
//        }
        mResStatusView.setVisibility(View.VISIBLE);
        mResStatusView.setText("0%");
        // 两个都回调，兼容老版本
        mCallback.onExtractStart(resType);
        mCallback.onExtractStart(resType, numerator);
    }

    public int lastProgress = 0;
    public int lastResType = 0;
    public boolean isExeProgressRun = false;
    private long initProbTime = 0;
    private long lastTime = 0;

    @Override
    public void onExtractProgress(int resType, float progress) {
        int currentProgress = mAdaptiveProgressBar.getProgress();
        lastResType = resType;
        Log.d(TAG, "onExtractProgress lastProgres=" + lastProgress + "  progress=" + progress + " currentProgress=" + mAdaptiveProgressBar.getProgress() + " resType:" + resType);
        if((progress*10) <= lastProgress){
            mAdaptiveProgressBar.setProgress(mAdaptiveProgressBar.getProgress() + 1);
        }else if(progress*10 < currentProgress){
            mAdaptiveProgressBar.setProgress(mAdaptiveProgressBar.getProgress() + 1);
        }else {
            lastProgress = currentProgress;
            mAdaptiveProgressBar.setProgress((int) (progress*10));
        }
        mStrDownloadStatus = getResources().getString(R.string.lebian_dl_status_extract);
        //显示下载进度
//        if (resType == 1) {
//            mResStatusView.setVisibility(View.VISIBLE);
//            mResStatusView.setText(String.format("%.2f", mAdaptiveProgressBar.getProgress()/10.0f).toString() + "%");
//        }

        mResStatusView.setVisibility(View.VISIBLE);
        mResStatusView.setText(String.format("%.2f", mAdaptiveProgressBar.getProgress()/10.0f).toString() + "%");
        mCallback.onExtractProgress(resType, progress);
    }

    @Override
    public void onExtractFinish(int resType) {
        mStrDownloadStatus = getResources().getString(R.string.lebian_merge_finish_restart);
        mTextStatusView.setText(mStrDownloadStatus);
//        if(resType == 1){
            mResStatusView.setText("100.00%");
//        }
        mCallback.onExtractFinish(resType);
    }

    @Override
    public void onComputeMD5Start(int resType) {
        mTextStatusView.setVisibility(View.VISIBLE);
        mTextProgressView.setVisibility(View.GONE);
        mAdaptiveProgressBar.setVisibility(View.VISIBLE);
        mDownloadSpeedView.setVisibility(View.GONE);
        mFrameAnimationView.setVisibility(View.GONE);
        mResStatusView.setVisibility(View.INVISIBLE);
        mAdaptiveProgressBar.setProgress(0);
        mStrDownloadStatus = getResources().getString(R.string.lebian_dl_status_compute_md5);
        mTextStatusView.setText(mStrDownloadStatus);
        resetImagePosition();
        mCallback.onComputeMD5Start(resType);
    }

    @Override
    public void onComputeMD5Progress(int resType, float progress) {
        mAdaptiveProgressBar.setProgress((int) (progress*10));
        mCallback.onComputeMD5Progress(resType, progress);
    }

    @Override
    public void onComputeMD5Finish(int resType) {
        resetImagePosition();
        mCallback.onComputeMD5Finish(resType);
    }

    @Override
    public void onError(int errorCode, String errorMsg) {
        if (errorCode == ErrorCode.CONNECT_ERROR.getCode()) {
            mStrDownloadStatus = getResources().getString(R.string.lebian_dl_status_no_network);
        } else if (errorCode == ErrorCode.NET_ERROR.getCode() || errorCode == ErrorCode.DOWNLOAD_ERROR.getCode()) {
            mStrDownloadStatus = getResources().getString(R.string.lebian_dl_dl_failed);
        } else if(errorCode == ErrorCode.MD5_ERROR.getCode() || errorCode == ErrorCode.PATCH_ERROR.getCode() || errorCode == ErrorCode.INSTALL_ERROR.getCode()){
            mStrDownloadStatus = getResources().getString(R.string.lebian_apply_patch_failed);
        }else {
            mStrDownloadStatus = errorMsg;
        }
        mTextStatusView.setText(mStrDownloadStatus);
        mCallback.onError(errorCode, errorMsg);
    }

    @Override
    public void onShowDialog(int type, Bundle bundle, DialogClickCallback dialogClickCallback) {
        mUIDialogManager.show(type, bundle, dialogClickCallback);
    }

    @Override
    public void onAutoDismissDialog(int type) {
        mUIDialogManager.autoDismiss(type);
    }

    @Override
    public void onDownloadConnecting(int resType) {
        prepareDownloadStatus();
    }

    //模拟下载进程，实际在应用中不执行，只在测试lbui时执行
    private static class ProgressSimulator {
        private boolean mIsTestMode = false;
        private LBDnsListener mListener;

        private Handler mHandler;

        public static final int RES_TYPE = 1;

        public static final int PROGRESS_START = 0;
        public static final int PROGRESS_PROGRESS = 1;
        public static final int PROGRESS_SIZE = 2;
        public static final int PROGRESS_SPEED = 3;
        public static final int PROGRESS_CONNECTING = 4;
        public static final int PROGRESS_FINISH = 5;
        public static final int PROGRESS_MD5_START = 6;
        public static final int PROGRESS_MD5_COMPUTE = 7;
        public static final int PROGRESS_MD5_FINISH = 8;
        public static final int PROGRESS_EXTRACT_START = 9;
        public static final int PROGRESS_EXTRACT_PROGRESS = 10;
        public static final int PROGRESS_EXTRACT_FINISH = 11;

        public ProgressSimulator(boolean isTestMode, LBDnsListener listener) {
            mIsTestMode = isTestMode;
            mListener = listener;
            Log.d(TAG, "ProgressSimulator test mode = " + isTestMode);
            if (isTestMode) {
                mHandler = new Handler(Looper.getMainLooper()) {
                    @Override
                    public void handleMessage(Message msg) {
                        super.handleMessage(msg);
                        switch (msg.what) {
                            case PROGRESS_START:
                                mListener.onDownloadStart(RES_TYPE, (String) msg.obj);
                                break;
                            case PROGRESS_PROGRESS:
                                mListener.onDownloadProgress(RES_TYPE, msg.arg1);
                                break;
                            case PROGRESS_SIZE:
                                mListener.onDownloadSize(msg.arg1, msg.arg2);
                                break;
                            case PROGRESS_SPEED:
                                mListener.onDownloadSpeed((Float) msg.obj);
                                break;
                            case PROGRESS_CONNECTING:
                                mListener.onDownloadConnecting(RES_TYPE);
                                break;
                            case PROGRESS_FINISH:
                                mListener.onDownloadFinish(RES_TYPE);
                                break;
                            case PROGRESS_MD5_START:
                                mListener.onComputeMD5Start(RES_TYPE);
                                break;
                            case PROGRESS_MD5_COMPUTE:
                                mListener.onComputeMD5Progress(RES_TYPE, msg.arg1);
                                break;
                            case PROGRESS_MD5_FINISH:
                                mListener.onComputeMD5Finish(RES_TYPE);
                                break;
                            case PROGRESS_EXTRACT_START:
                                mListener.onExtractStart(RES_TYPE, "1/1");
                                break;
                            case PROGRESS_EXTRACT_PROGRESS:
                                mListener.onExtractProgress(RES_TYPE, msg.arg1);
                                break;
                            case PROGRESS_EXTRACT_FINISH:
                                mListener.onExtractFinish(RES_TYPE);
                                break;
                            default:
                                break;
                        }
                    }
                };
            }
        }

        private void progressSimulate() {
            if (mIsTestMode) {

                Log.d(TAG, "ProgressSimulator test mode 1 = " + mIsTestMode);
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        mHandler.sendMessage(mHandler.obtainMessage(PROGRESS_CONNECTING));
                        sleep(1000);
                        mHandler.sendMessage(mHandler.obtainMessage(PROGRESS_START, "1/1"));
                        sleep(1000);
                        for (int i = 0; i <= 100; i++) {
                            Message message = new Message();
                            message.what = PROGRESS_PROGRESS;
                            message.arg1 = i;
                            mHandler.sendMessage(message);
                            Message message2 = new Message();
                            message2.what = PROGRESS_SIZE;
                            message2.arg1 = i * 1024 * 1024;
                            message2.arg2 = 100 * 1024 * 1024;
                            mHandler.sendMessage(message2);

                            Message message3 = new Message();
                            message3.what = PROGRESS_SPEED;
                            message3.obj = 100f;
                            mHandler.sendMessage(message3);
                            sleep(100);
                        }
                        mHandler.sendMessage(mHandler.obtainMessage(PROGRESS_MD5_START));
                        sleep(1000);
                        for (int i = 0; i <= 100; i++) {
                            Message message = new Message();
                            message.what = PROGRESS_MD5_COMPUTE;
                            message.arg1 = i;
                            mHandler.sendMessage(message);
                        }

                        mHandler.sendMessage(mHandler.obtainMessage(PROGRESS_MD5_FINISH));
                        sleep(100);

                        mHandler.sendMessage(mHandler.obtainMessage(PROGRESS_EXTRACT_START));
                        sleep(100);

                        for (int i = 0; i <= 100; i++) {
                            Message message = new Message();
                            message.what = PROGRESS_EXTRACT_PROGRESS;
                            message.arg1 = i;
                            mHandler.sendMessage(message);
                            sleep(50);
                        }

                        if (RES_TYPE == 2) {
                            mHandler.sendMessage(mHandler.obtainMessage(PROGRESS_FINISH));
                        } else {
                            mHandler.sendMessage(mHandler.obtainMessage(PROGRESS_EXTRACT_FINISH));

                        }
                    }
                }).start();
            }
        }

        private void sleep(int m) {
            try {
                Thread.sleep(m);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}
