package com.excelliance.open;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;

import com.excelliance.open.library.LBDnsListener;
import com.excelliance.open.library.NextChapterInterface;

import java.lang.reflect.Constructor;

public class NextChapterHelper extends BaseUIHelper{
    private static final String TAG = "NextChapterHelper";

    public static final int MODE_IMAGE = 0;
    public static final int MODE_MP4 = 1;
    public static final int MODE_GIF = 2;

    private NextChapterInterface mNextChapterImpl;

    public NextChapterHelper() {
    }

    public NextChapterHelper(Activity mActivity) {
        super(mActivity);
    }

    public void init(Handler handler, Intent intent, LBDnsListener self) {
        mNextChapterImpl = getNextChapterImpl();
        if (mNextChapterImpl != null) {
            mNextChapterImpl.init(self, handler, intent);
        }else{
            mMode = MODE.TEST;
        }
    }

    private NextChapterInterface getNextChapterImpl() {
        NextChapterInterface obj = null;
        try {
            Class clazz = getClass("main.ui.NextChapterImpl");
            Constructor cons = clazz.getDeclaredConstructor();
            cons.setAccessible(true);
            obj = (NextChapterInterface) cons.newInstance();
        } catch (Exception e) {
            Log.d(TAG, "no NextChapterImpl");
            e.printStackTrace();
        }

        return obj;
    }

    /**
     * MODE_IMAGE = 0;轮播图
     * MODE_MP4 = 1; mp4视频
     * MODE_GIF = 2; gif
     * @return
     */
    public int getSwitchViewMode(){
        return MODE_MP4;
    }


    public void prepareViewFinished() {
        if (mNextChapterImpl != null) {
            mNextChapterImpl.prepareViewFinished();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        try {
            if (mNextChapterImpl != null) {
                mNextChapterImpl.onCreate(savedInstanceState);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void onResume() {
        try {
            if (mNextChapterImpl != null) {
                mNextChapterImpl.onResume();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void onPause() {
        try {
            if (mNextChapterImpl != null) {
                mNextChapterImpl.onPause();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }


    public void onStop() {
        try {
            if (mNextChapterImpl != null) {
                mNextChapterImpl.onStop();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void onDestroy() {
        try {
            if (mNextChapterImpl != null) {
                mNextChapterImpl.onDestroy();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean ret = false;
        try {
            if (mNextChapterImpl != null) {
                ret = mNextChapterImpl.onKeyDown(keyCode,event);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        return ret;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        try {
            if (mNextChapterImpl != null) {
                mNextChapterImpl.onConfigurationChanged(newConfig);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }


}
