package com.excelliance.open;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.excelliance.open.library.DialogClickCallback;
import com.excelliance.lbui.R;
import com.excelliance.open.custom.CustomClickCallback;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

public class NewCustomDialog extends Dialog {

    private Bundle mBundle;
    private DialogClickCallback mDialogClickCallback;
    private CustomClickCallback mCustomClickCallback;
    private int mType;
    private TextView mMessageTextView;


    public void setMessage(String message) {
        if (mMessageTextView != null)
            this.mMessageTextView.setText(message);
    }

    public void setParams(Bundle bundle) {
        mBundle = bundle;
    }

    public Bundle getParams() {
        return mBundle;
    }

    public void setClickCallback(DialogClickCallback clickCallback){
        mDialogClickCallback = clickCallback;
    }

    public DialogClickCallback getClickCallback() {
        return mDialogClickCallback;
    }

    public void setCustomClickCallback(CustomClickCallback clickCallback){
        mCustomClickCallback = clickCallback;
    }

    public CustomClickCallback getCustomClickCallback() {
        return mCustomClickCallback;
    }

    public void setDialogType(int type){
        mType = type;
    }

    public int getType() {
        return mType;
    }

    public NewCustomDialog(Context context, int theme) {
        super(context, theme);
    }

    public NewCustomDialog(Context context) {
        super(context);
    }

    /**
     * Helper class for creating a custom dialog
     */
    public static class Builder extends AliveDialogLayer.Builder{
        private Context context;
        private String title;
        private String message;
        private String positiveButtonText;
        private String negativeButtonText;
        private View contentView;

        private CheckBox checkBox;
        private String checkBoxText;
        private boolean checked;
        private CompoundButton.OnCheckedChangeListener checkBoxListener;

        private boolean navigation;
        private boolean mCancelable;
        private OnKeyListener mOnKeyListener;
        private int dialogType;
        private Bundle mBundle;
        private DialogClickCallback mDialogClickCallback;
        private CustomClickCallback mCustomClickCallback;

        private DialogInterface.OnClickListener
                positiveButtonClickListener,
                negativeButtonClickListener;

        public Builder(Context context) {
            super(context);
            this.context = new BaseActivity.LebianContext(context, android.R.style.Theme, BwbxUI.getResources(context));
        }

        public Builder(Context context, Context topActivity) {
            super(context);
            this.context = new BaseActivity.LebianContext(topActivity, android.R.style.Theme, BwbxUI.getResources(context));
        }

        @Override
        protected Dialog onCreate(Activity activity) {
            this.context = new BaseActivity.LebianContext(activity, android.R.style.Theme, BwbxUI.getResources(context));
            return create();
        }

        /**
         * Set the Dialog message from String
         * @return
         */
        public NewCustomDialog.Builder setMessage(String message) {
            if (notEqualString(this.message, message)) {
                this.message = message;
                invalidate();
            }
            return this;
        }

        /**
         * Set the Dialog title from String
         * @param title
         * @return
         */
        public NewCustomDialog.Builder setTitle(String title) {
            if (notEqualString(this.title, title)) {
                this.title = title;
                invalidate();
            }
            return this;
        }

        /**
         * Set a custom content view for the Dialog.
         * If a message is set, the contentView is not
         * added to the Dialog...
         * @param v
         * @return
         */
        public NewCustomDialog.Builder setContentView(View v) {
            this.contentView = v;
            return this;
        }

        /**
         * Set the positive button text and it's listener
         * @param positiveButtonText
         * @param listener
         * @return
         */
        public NewCustomDialog.Builder setPositiveButton(String positiveButtonText,
                                                      DialogInterface.OnClickListener listener) {
            this.positiveButtonText = positiveButtonText;
            this.positiveButtonClickListener = listener;
            return this;
        }

        /**
         * Set the negative button text and it's listener
         * @param negativeButtonText
         * @param listener
         * @return
         */
        public NewCustomDialog.Builder setNegativeButton(String negativeButtonText,
                                                      DialogInterface.OnClickListener listener) {
            this.negativeButtonText = negativeButtonText;
            this.negativeButtonClickListener = listener;
            return this;
        }

        public NewCustomDialog.Builder setCheckBox(String checkBoxText, boolean checked,
                                                CompoundButton.OnCheckedChangeListener listener) {
            this.checkBoxText = checkBoxText;
            this.checked = checked;
            this.checkBoxListener = listener;
            return this;
        }
        public boolean getChecked() {
            if(this.checkBox != null) {
                return this.checkBox.isChecked();
            } else {
                return false;
            }
        }

        public NewCustomDialog.Builder setNav(boolean nav) {
            navigation = nav;
            return this;
        }

        /**
         * Create the custom dialog
         */
        public NewCustomDialog create() {
            if (context == null) {
                return null;
            }
            Resources res = BaseUIHelper.getResources(context);
            LayoutInflater inflater = (LayoutInflater) context
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            // instantiate the dialog with the custom Theme
            inflater = inflater.cloneInContext(context);
            try {
                Class inflateClass = Class.forName("android.view.LayoutInflater", false, context.getClassLoader());
                Field f1 = inflateClass.getDeclaredField("mFactory");
                f1.setAccessible(true);
                Field f2 = inflateClass.getDeclaredField("mFactory2");
                f2.setAccessible(true);
                f1.set(inflater,null);
                f2.set(inflater,null);
            } catch (Exception e) {
                e.printStackTrace();
            }
            final NewCustomDialog dialog =new NewCustomDialog(context, R.style.lebian_dialog_theme);
            dialog.getWindow().setBackgroundDrawableResource(android.R.color.transparent);
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
            View layout = inflater.inflate(R.layout.lebian_dialog, null);
            // set the header background
            LinearLayout headerLayout = (LinearLayout)layout.findViewById(R.id.lebian_dialog_header_layout);

            Drawable d = res.getDrawable(R.drawable.lebian_header);
            headerLayout.setBackgroundDrawable(d);
            // set the center background
            LinearLayout contentLayout = (LinearLayout)layout.findViewById(R.id.lebian_content);

            d = res.getDrawable(R.drawable.lebian_center);
            contentLayout.setBackgroundDrawable(d);
            // set the dialog title
            TextView titleTextView = (TextView) layout.findViewById(R.id.lebian_title);
            titleTextView.setText(title);
            // set the footer background
            LinearLayout footerLayout = (LinearLayout)layout.findViewById(R.id.lebian_dialog_footer_layout);

            d = res.getDrawable(R.drawable.lebian_footer);
            footerLayout.setBackgroundDrawable(d);
            // set the confirm button
            if (positiveButtonClickListener != null) {
                View v = layout.findViewById(R.id.lebian_positiveButton);
                StateListDrawable sdrawable = new StateListDrawable();
                Drawable pressed = res.getDrawable(R.drawable.lebian_btn_positive_pressed);
                Drawable normal = res.getDrawable(R.drawable.lebian_btn_positive_normal);
                sdrawable.addState(new int[]{android.R.attr.state_pressed}, pressed);
                sdrawable.addState(new int[]{android.R.attr.state_focused}, pressed);
                sdrawable.addState(new int[]{}, normal);
                v.setBackgroundDrawable(sdrawable);
                if (positiveButtonText != null) {
                    if ( v instanceof Button){
                        ((Button) v).setText(positiveButtonText);
                    }
                    else if( v instanceof TextView){
                        ((TextView) v).setText(positiveButtonText);
                    }
                }
                v.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View v) {
                        if (dialog.getClickCallback() != null) {
                            dialog.getClickCallback().onPositiveClick(dialog.getType(),dialog.getParams());
                        }
                        if (dialog.getCustomClickCallback() != null) {
                            dialog.getCustomClickCallback().onPositiveClick(dialog.getType(),dialog.getParams());
                        }
                        DialogInterface dialogInterface = getAttachLayer();
                        if (null == dialogInterface) {
                            dialogInterface = dialog;
                        }
                        positiveButtonClickListener.onClick(
                                dialogInterface,
                                DialogInterface.BUTTON_POSITIVE);
                    }
                });

            } else {
                View v = layout.findViewById(R.id.lebian_positiveButton);
                // if no confirm button just set the visibility to GONE
                v.setVisibility(
                        View.GONE);
            }
            // set the cancel button
            if (negativeButtonClickListener != null) {
                View v = layout.findViewById(R.id.lebian_negativeButton);
                StateListDrawable sdrawable = new StateListDrawable();
                Drawable pressed = res.getDrawable(R.drawable.lebian_btn_negative_pressed);
                Drawable normal = res.getDrawable(R.drawable.lebian_btn_negative_normal);
                sdrawable.addState(new int[]{android.R.attr.state_pressed}, pressed);
                sdrawable.addState(new int[]{android.R.attr.state_focused}, pressed);
                sdrawable.addState(new int[]{}, normal);
                v.setBackgroundDrawable(sdrawable);
                if (negativeButtonText != null) {
                    if ( v instanceof Button){
                        ((Button)v).setText(negativeButtonText);
                    }
                    else if( v instanceof TextView){
                        ((TextView) v).setText(negativeButtonText);
                    }
                }
                v.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View v) {
                        if (dialog.getClickCallback() != null) {
                            dialog.getClickCallback().onNegativeClick(dialog.getType(),dialog.getParams());
                        }
                        if (dialog.getCustomClickCallback() != null) {
                            dialog.getCustomClickCallback().onNegativeClick(dialog.getType(),dialog.getParams());
                        }
                        DialogInterface dialogInterface = getAttachLayer();
                        if (null == dialogInterface) {
                            dialogInterface = dialog;
                        }
                        negativeButtonClickListener.onClick(
                                dialogInterface,
                                DialogInterface.BUTTON_NEGATIVE);
                    }
                });

            } else {

                // if no confirm button just set the visibility to GONE
                View v = layout.findViewById(R.id.lebian_negativeButton);
                v.setVisibility(View.GONE);
            }
            // set the content message
            if (message != null) {
                dialog.mMessageTextView = (TextView)layout.findViewById(R.id.lebian_message);
                dialog.mMessageTextView.setText(message);
            } else if (contentView != null) {
                // if no message set
                // add the contentView to the dialog body
                contentLayout.removeAllViews();
                contentLayout.addView(contentView,
                        new ViewGroup.LayoutParams(
                                ViewGroup.LayoutParams.WRAP_CONTENT,
                                ViewGroup.LayoutParams.WRAP_CONTENT));
            }

            if(checkBoxText != null) {
                LinearLayout checkBoxLayout = (LinearLayout)layout.findViewById(R.id.lebian_check_box_layout);
                d = res.getDrawable(R.drawable.lebian_down_center);
                checkBoxLayout.setBackgroundDrawable(d);
                checkBoxLayout.setVisibility(View.VISIBLE);
                checkBox = (CheckBox)layout.findViewById(R.id.lebian_check_box);
                //checkBox.setButtonDrawable(null);
                checkBox.setText(checkBoxText);
                StateListDrawable sdrawable = new StateListDrawable();
                Drawable checked = res.getDrawable(R.drawable.lebian_checkbox_bg_checked);
                Drawable normal = res.getDrawable(R.drawable.lebian_checkbox_bg_normal);
                sdrawable.addState(new int[]{android.R.attr.state_checked}, checked);
                sdrawable.addState(new int[]{-android.R.attr.state_checked}, normal);
                sdrawable.addState(new int[]{}, normal);
                checkBox.setButtonDrawable(sdrawable);

                if(checkBoxListener != null) {
                    checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                        @Override
                        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                            if (dialog.getClickCallback() != null)
                                dialog.getClickCallback().onCheckBox(dialog.getType(), dialog.getParams(),isChecked);
                            if (dialog.getCustomClickCallback() != null) {
                                dialog.getCustomClickCallback().onCheckBox(dialog.getType(),dialog.getParams(),isChecked);
                            }
                            checkBoxListener.onCheckedChanged(buttonView, isChecked);
                        }
                    });
                }
                checkBox.setChecked(this.checked);
            }

            dialog.setContentView(layout);
            boolean nav = navigation;
            if (nav && Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                dialog.getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
            }
            dialog.setCancelable(mCancelable);
            dialog.setOnKeyListener(mOnKeyListener);
            dialog.setDialogType(dialogType);
            dialog.setClickCallback(mDialogClickCallback);
            dialog.setCustomClickCallback(mCustomClickCallback);
            dialog.setParams(mBundle);
            return dialog;
        }

        /**
         * Sets whether this dialog is cancelable with the
         * {@link KeyEvent#KEYCODE_BACK BACK} key.
         */
        public NewCustomDialog.Builder setCancelable(boolean flag) {
            if (mCancelable != flag) {
                mCancelable = flag;
                invalidate();
            }
            return this;
        }

        /**
         * Sets the callback that will be called if a key is dispatched to the dialog.
         */
        public NewCustomDialog.Builder setOnKeyListener(OnKeyListener onKeyListener) {
            if (mOnKeyListener != onKeyListener) {
                mOnKeyListener = onKeyListener;
                invalidate();
            }
            return this;
        }

        public NewCustomDialog.Builder setDialogType(int type){
            if (type != dialogType) {
                dialogType = type;
                invalidate();
            }
            return this;
        }

        public NewCustomDialog.Builder setParams(Bundle bundle) {
            mBundle = bundle;
            if (notEqualBundles(mBundle, bundle)) {
                mBundle.clear();
                mBundle.putAll(bundle);
                invalidate();
            }
            return this;
        }

        public NewCustomDialog.Builder setClickCallback(DialogClickCallback clickCallback){
            if (mDialogClickCallback != clickCallback) {
                mDialogClickCallback = clickCallback;
                invalidate();
            }
            return this;
        }

        public NewCustomDialog.Builder setCustomClickCallback(CustomClickCallback clickCallback){
            if (mCustomClickCallback != clickCallback) {
                mCustomClickCallback = clickCallback;
                invalidate();
            }
            return this;
        }
    }

    private static boolean notEqualBundles(Bundle one, Bundle two) {
        if (null == one && null == two) {
            return false;
        } else if (null == one || null == two) {
            return true;
        }

        if(one.size() != two.size())
            return true;

        Set<String> setOne = new HashSet<>(one.keySet());
        setOne.addAll(two.keySet());
        Object valueOne;
        Object valueTwo;

        for(String key : setOne) {
            if (!one.containsKey(key) || !two.containsKey(key))
                return true;

            valueOne = one.get(key);
            valueTwo = two.get(key);
            if(valueOne instanceof Bundle && valueTwo instanceof Bundle &&
                    notEqualBundles((Bundle) valueOne, (Bundle) valueTwo)) {
                return true;
            }
            else if(valueOne == null) {
                if(valueTwo != null)
                    return true;
            }
            else if(!valueOne.equals(valueTwo))
                return true;
        }
        return false;
    }

    private static boolean notEqualString(String o1, String o2) {
        if (null != o1) {
            return !o1.equals(o2);
        }
        if (null != o2) {
            return !o2.equals(o1);
        }
        return false;
    }

    @Override
    public void dismiss() {
        super.dismiss();
        DialogClickCallback callback = getClickCallback();
        if (null != callback) {
            callback.dismiss();
        }
    }
}
