package com.excelliance.open;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.widget.FrameLayout;

import com.excelliance.open.gif.GifImageView;
import com.excelliance.open.video.VideoView;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LBSwitchView extends FrameLayout {
    public static final String TAG = "LBSwitchView";
    private final List<AdaptiveImageView.ImageItem> mImages = new ArrayList<>();
    private final Context mContext;
    private Handler mHandler;
    private int mCount = 0;
    private final int mTime = 5000;//图片显示的时长
    private final int mAniTime = 1500;//淡入淡出显示的时长
    private final int mNoAniTime = 0;
    private AdaptiveImageView mTopImageView;
    private AdaptiveImageView mBottomImageView;
    private LbUiWindowManager mLbWindowManager;
    private VideoView mVideoView;
    public static final String BG_NAME = "lebian_main_background_normal";

    public LBSwitchView(Context context) {
        this(context, null);
    }

    public LBSwitchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        mContext = context;
        mHandler = new Handler(Looper.getMainLooper());
        Resources mainRes = BwbxUI.getResources(context);
        Resources apkRes = BwbxUI.getApkResources(context);
        mLbWindowManager = LbUiWindowManager.getInstance(mContext);
        NextChapterHelper nextChapterHelper = new NextChapterHelper();
        try {
            switch (nextChapterHelper.getSwitchViewMode()) {
                case NextChapterHelper.MODE_IMAGE:
                    //优先初始化apk内部图片资源
                    if (!initResourceImage(apkRes) && !nextChapterHelper.isTestMode()) {
                        //初始化新版本的图片资源
                        if (!initNewVersionImage()) {
                            //初始化jar包的资源
                            if (!initResourceImage(mainRes)) {
                                Log.d(TAG, "no background image");
                            }
                        }
                    }
                    startCyclePlayImage();
                    break;
                case NextChapterHelper.MODE_MP4:
                    initVideo();
                    break;
                case NextChapterHelper.MODE_GIF:
                    initGif();
                    break;
                default:

            }

        }catch (Throwable throwable){
            Log.e(TAG, throwable.getMessage());
            //发生崩溃的时候，加载一张默认图片
            AdaptiveImageView.ImageItem imageItem;
            try {
                AdaptiveImageView iv = new AdaptiveImageView(context);
                int v = apkRes.getIdentifier(BG_NAME, "drawable", context.getPackageName());
                if (v > 0) {
                    imageItem = new AdaptiveImageView.ImageItem(apkRes, v);
                } else {
                    v = mainRes.getIdentifier(BG_NAME, "drawable", context.getPackageName());
                    imageItem = new AdaptiveImageView.ImageItem(mainRes, v);
                }
                addView(iv, new LayoutParams(mLbWindowManager.getScreenWidth(), mLbWindowManager.getScreenHeight()));
                iv.setImageItemShow(imageItem);
            } catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void initVideo(){
        VideoView videoView = new VideoView(mContext);
        addView(videoView);
    }

    private void initGif(){
        GifImageView gifView = new GifImageView(mContext);
        addView(gifView);
    }


    private boolean initResourceImage(Resources res) {
        int sourceId = getImageSourceId(res, BG_NAME);
        if (sourceId > 0) {
            mImages.add(new AdaptiveImageView.ImageItem(res, sourceId));
        }
        for (int i = 1; i < 10; i++) {
            sourceId = getImageSourceId(res, BG_NAME + "_" + (i));
            if (sourceId > 0) {
                mImages.add(new AdaptiveImageView.ImageItem(res, sourceId));
            } else {
                break;
            }
        }
        return !mImages.isEmpty();
    }

    private int getImageSourceId(Resources res, String bgName) {
        return res.getIdentifier(bgName, "drawable", mContext.getPackageName());
    }

    /**
     * 新版本image不存放到app中，通过制定path获取
     */
    private boolean initNewVersionImage() {
        for (int i = 0; i < 10; i++) {
            String path = getNewVersionImagePath(i);
            if (path == null) {
                break;
            } else {
                mImages.add(new AdaptiveImageView.ImageItem(path));
            }
        }
        return !mImages.isEmpty();
    }


    private void startCyclePlayImage() {
        removeAllViews();
        if (!mImages.isEmpty()) {
            if (mTopImageView == null) {
                mTopImageView = new AdaptiveImageView(mContext);
                LayoutParams layoutParams = new LayoutParams(mLbWindowManager.getScreenWidth(), mLbWindowManager.getScreenHeight());
                addView(mTopImageView, layoutParams);
            }
            //图片超过两个，多加一个ImageView，目的为了动画效果
            if (mImages.size() > 1 && mBottomImageView == null) {
                mBottomImageView = new AdaptiveImageView(mContext);
                LayoutParams layoutParams = new LayoutParams(mLbWindowManager.getScreenWidth(), mLbWindowManager.getScreenHeight());
                addView(mBottomImageView, layoutParams);
            }
            //开始轮播动画
            startImageAnim();
        } else {
            Log.d(TAG, "image is empty");
        }
    }

    private void startImageAnim() {
        final int size = mImages.size();
        Log.d(TAG, "startImageAnim image size :" + size);
        mCount = 0;
        if (size > 1) {
            mHandler.post(new Runnable() {
                @Override
                public void run() {
                    final int index = mCount % size;
                    //第一张不需要动画效果
                    if (mCount == 0) {
                        if (mTopImageView != null) {
                            mTopImageView.setImageItemShow(mImages.get(0));
                        }
                    } else {
                        //轮播到最后一张了，从第一张开始轮播
                        if (index >= size) {
                            doInOutAnimation(0);
                        } else {
                            doInOutAnimation(index);
                        }
                    }
                    mCount++;
                    mHandler.postDelayed(this, mTime);
                }
            });
        }else {
            if (mTopImageView != null) {
                mTopImageView.setImageItemShow(mImages.get(0));
            }
        }
    }


    private void doInOutAnimation(int index) {
        if (mBottomImageView != null && mTopImageView != null) {
            if (mCount % 2 == 0) {
                mTopImageView.setImageItemShow(mImages.get(index));
                mBottomImageView.startAnimation(createOutAwayAnim());
                mTopImageView.startAnimation(createOutNearAnim());

            } else {
                mBottomImageView.setImageItemShow(mImages.get(index));
                mTopImageView.startAnimation(createOutAwayAnim());
                mBottomImageView.startAnimation(createOutNearAnim());
            }
        }
    }

    //创建一个淡出的动画
    public Animation createOutAwayAnim() {
        AnimationSet ret = new AnimationSet(false);
        Animation anim = new AlphaAnimation(1f, 0f);//淡出动画
        if (BwbxUI.getGlobalBoolean(mContext, "USE_ANIMAL_WHEN_SWITCH_VIEW", true)) {
            anim.setDuration(mAniTime);
        } else {
            anim.setDuration(mNoAniTime);
        }
        anim.setInterpolator(new AccelerateDecelerateInterpolator());
        ret.addAnimation(anim);
        ret.setFillAfter(true);
        return ret;
    }

    //创建一个淡入的动画
    public Animation createOutNearAnim() {
        AnimationSet ret = new AnimationSet(false);
        Animation anim = new AlphaAnimation(0f, 1f);//淡入动画
        if (BwbxUI.getGlobalBoolean(mContext, "USE_ANIMAL_WHEN_SWITCH_VIEW", true)) {
            anim.setDuration(mAniTime);
        } else {
            anim.setDuration(mNoAniTime);
        }
        anim.setInterpolator(new AccelerateDecelerateInterpolator());
        ret.addAnimation(anim);
        ret.setFillAfter(true);
        return ret;
    }


    private String getNewVersionImagePath(int index) {
        String path = mContext.getApplicationInfo().dataDir + "/lebian/";
        String name = BG_NAME + "_" + index + ".jpg";
        File file = new File(path + name);
        if (file.exists()) {
            return file.getAbsolutePath();
        } else {
            return null;
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        mHandler.removeCallbacksAndMessages(null);
        mHandler = null;
    }

    public void onStop() {
        if (mVideoView != null) {
            mVideoView.onStop();
        }
    }

    public void onDestroy() {
        if (mVideoView != null) {
            mVideoView.onDestroy();
        }
    }
}
