package com.excelliance.open;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.excelliance.open.utils.BitmapUtils;

/**
 * 自适应的ImageView
 */
public class AdaptiveImageView extends ImageView {
    //原始图片信息
    private ImageItem mOriginalImageItem = null;
    private int mScreenWidth;
    private int mScreenHeight;
    private Context mContext;
    private LbUiWindowManager mLbUiWindowManager;

    public AdaptiveImageView(Context context) {
        this(context, null);
    }

    public AdaptiveImageView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        init(context);
    }


    private void init(Context context) {
        mContext = context;
        mLbUiWindowManager = LbUiWindowManager.getInstance(context);
        int sMode = BwbxUI.getGlobalInt(mContext, "SCALE_MODE_IN_NEXTCHAPTER", 0);
        if (sMode == 0) {
            setScaleType(ScaleType.CENTER_CROP);
        } else if (sMode == 1) {
            setScaleType(ScaleType.FIT_CENTER);
        } else {
            setScaleType(ScaleType.FIT_XY);
        }
        updateScreenWidthAndHeight();
    }

    /**
     * 显示图片的时候去获取图片
     */
    public void setImageItemShow(ImageItem originalImageItem) {
        mOriginalImageItem = originalImageItem;
        Bitmap picture = originalImageItem.getBitmap();
        if (picture != null) {
            setImageBitmap(picture);
        }
    }

    static class ImageItem {
        private int mSourceId;
        private Resources mResource;
        private int mType;
        private String mPath;

        ImageItem(String path) {
            mPath = path;
            mType = 1;
        }

        ImageItem(Resources resource, int id) {
            mResource = resource;
            mSourceId = id;
            mType = 0;
        }


        Bitmap getBitmap() {
            if (mType == 0) {
                return BitmapFactory.decodeResource(mResource, mSourceId);
            } else if (mType == 1) {
                return BitmapFactory.decodeFile(mPath);
            } else {
                return null;
            }
        }
    }

    //更新手机屏幕的宽高
    private void updateScreenWidthAndHeight() {
        mScreenWidth = mLbUiWindowManager.getScreenWidth();
        mScreenHeight = mLbUiWindowManager.getScreenHeight();
    }


    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        updateScreenWidthAndHeight();
        updateBitmap();
        updateLayoutParams(mScreenWidth, mScreenHeight);
    }

    private void updateBitmap() {
        if (mOriginalImageItem != null) {
            Bitmap bitmap = mOriginalImageItem.getBitmap();
            if (bitmap != null) {
                setImageBitmap(bitmap);
            }
        }
    }

    private void updateLayoutParams(int width, int height) {
        ViewGroup.LayoutParams layoutParams = getLayoutParams();
        layoutParams.height = height;
        layoutParams.width = width;
        setLayoutParams(layoutParams);
    }
}
