package com.excelliance.open.utils;

import android.content.Context;

import com.excelliance.open.library.UploadResult;
import com.excelliance.open.reflect.Reflector;

/**
 * 调用lbmain模块里的函数
 */
public class MainUtil {
    private static final String TAG = "MainUtil";

    private static final String LBSDK_PKG_NAME = "com.excelliance.assetsonly";
    private static final String ASSETSONLY_PKG_NAME = "com.excelliance.assetsonly";
    private static final String MAIN_HELPER_CLASS = ".main.LBSdkHelper";

    /**
     * 记录反射调用class名字
     */
    private static String mainHelperClass;
    
    public static UploadResult uploadRecord(Context context, int ftype, String mark) {
        UploadResult ret = (UploadResult) invokeMainHelperMethod("uploadRecord",
                new Class[]{Context.class, int.class, String.class}, new Object[]{context, ftype, mark});
        return ret;
    }

    public static boolean isStillPutInSmall(Context context) {
        Boolean ret = (Boolean) invokeMainHelperMethod("isStillPutInSmall",
                new Class[]{Context.class}, new Object[]{context});
        return ret.booleanValue();
    }

    public static boolean clearRecord(Context context) {
        Integer ret = (Integer) invokeMainHelperMethod("clearRecord",
                new Class[]{Context.class}, new Object[]{context});
        if (null != ret) {
            return 0 == ret.intValue();
        }
        return false;
    }

    private static Object invokeMainHelperMethod(String method, Class[] paramTypes, Object[] params) {
        String className = mainHelperClass;
        if (null == className) {
            String[] candidates = new String[] {
                    LBSDK_PKG_NAME + MAIN_HELPER_CLASS,
                    ASSETSONLY_PKG_NAME + MAIN_HELPER_CLASS
            };

            Exception exception = null;
            for (int i = 0; i < candidates.length; i++) {
                className = candidates[i];
                try {
                    Class.forName(className);
                    mainHelperClass = className;
                    exception = null;
                    break;
                } catch (ClassNotFoundException e) {
                    exception = e;
                }
            }
            if (null != exception) {
                throw new RuntimeException(exception);
            }
        }
        Reflector reflector = new Reflector(className);
        return reflector.invoke(method, paramTypes, params);
    }
}
