package com.excelliance.open.floatwindow;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import com.excelliance.open.library.UploadResult;
import com.excelliance.lbui.R;
import com.excelliance.open.BaseActivity;
import com.excelliance.open.BwbxUI;
import com.excelliance.open.dialog.InputDialog;
import com.excelliance.open.dialog.UploadDialog;
import com.excelliance.open.utils.LayoutInflaterUtil;
import com.excelliance.open.utils.MainUtil;

public class RecordFloatWindow extends BaseFloatWindow implements View.OnClickListener, InputDialog.OnInputListener {

    private static long mSize = 0;
    private static int mCount = 0;
    private TextView mSizeTv;

    private boolean isUploading;
    private boolean isClearing;
    private Activity mActivity;

    private UploadDialog uploadDialog;
    private InputDialog inputDialog;

    /**
     * 列表标识. 1, 小包内; 2, 小包外
     */
    private int fType;
    private TextView fTypeButton;

    public RecordFloatWindow(Context context, Activity activity) {
        super(context,activity);
        mActivity = activity;
    }

    @Override
    protected View getLogoView(LayoutInflater inflater) {
        Context context = inflater.getContext();
        Resources res = BwbxUI.getResources(context);
        Context newContext = new BaseActivity.LebianContext(context, android.R.style.Theme, res);
        inflater = inflater.cloneInContext(newContext);
        LayoutInflaterUtil.disableFactory(context, inflater);
        ViewGroup view = (ViewGroup) inflater.inflate(R.layout.lebian_float_window_record, null);
        mSizeTv = view.findViewById(R.id.lebian_float_size_text);
        return view;
    }

    @Override
    protected void doOpen() {
        if (null == uploadDialog) {
            uploadDialog = new UploadDialog(mActivity);
            uploadDialog.setOnUploadClickListener(RecordFloatWindow.this);
        }
        if (!uploadDialog.isShowing()) {
            uploadDialog.show();
        }
    }

    public void setPkgSize(int count, long size){
        mSize = size;
        mCount = count;
        double dsize = size;
        dsize = dsize / (1024 * 1024);
        mSizeTv.setText(String.format("%dM\n%d条", (int)Math.ceil(dsize), count));
    }

    @Override
    public void show() {
        super.show();
        setPkgSize(mCount, mSize);
    }

    public void destroy() {
        super.destroy();
        mActivity = null;
        mContext = null;
    }

    private String getPackageName(){
        return mContext.getPackageName();
    }

    
    private void uploadRecord(final Context context, final int ftype, final TextView button, final String mark) {
        if (isUploading) {
            return;
        }
        isUploading = true;
        final Handler handler = new Handler();
        final String text = button.getText().toString();
        button.setText("上传中...");
        new Thread(new Runnable() {
            @Override
            public void run() {
                final UploadResult uploadResult = MainUtil.uploadRecord(context, ftype, mark);
                handler.post(new Runnable() {
                    @Override
                    public void run() {
                        endUpload(uploadResult);
                        button.setText(text);
                    }
                });
            }
        }).start();
    }
    
    private void endUpload(UploadResult uploadResult) {
        isUploading = false;

        String toastText;
        if (uploadResult.isSuccess()) {
            String userId = uploadResult.getUserId();
            toastText = "数据上传成功，本次uid为" + userId;
        } else {
            toastText = uploadResult.getMsg();
        }
        // 防止窗口关闭, 网络延迟
        if (null != mContext) {
            Toast.makeText(mContext, toastText, Toast.LENGTH_LONG).show();
        }


        if (null != uploadDialog) {
            uploadDialog.dismiss();
        }
    }

    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.lebian_upload_record) {
            fType = 2;
            fTypeButton = (TextView) v;
            showInputDialog("上传小包外资源");
        } else if (viewId == R.id.lebian_keep_small) {
            fType = 1;
            fTypeButton = (TextView) v;
            showInputDialog("上传小包内资源");
        } else if (viewId == R.id.lebian_clear_data) {
            clearRecord(mContext, (TextView) v);
        } else {
            // do nothing
        }
    }

    private void showInputDialog(String title) {
        if (null == inputDialog) {
            inputDialog = new InputDialog(mActivity);
            inputDialog.setOnInputListener(this);
        }
        inputDialog.setTitle(title);
        if (!inputDialog.isShowing()) {
            inputDialog.show();
        }

        if (null != uploadDialog) {
            uploadDialog.dismiss();
        }
    }

    @Override
    public void onInput(int which, String input) {
        if (which == Dialog.BUTTON_POSITIVE) {
            if (null != uploadDialog) {
                uploadDialog.show();
            }
            String mark = input;
            mark = mark.trim();
            uploadRecord(mContext, fType, fTypeButton, mark);
        }
    }

    private void clearRecord(final Context context, final TextView button) {
        if (isClearing) {
            return;
        }
        isClearing = true;
        final Handler handler = new Handler();
        final String text = button.getText().toString();
        button.setText("清除中...");
        new Thread(new Runnable() {
            @Override
            public void run() {
                final boolean ok = MainUtil.clearRecord(context);
                handler.post(new Runnable() {
                    @Override
                    public void run() {
                        endClear(ok);
                        button.setText(text);
                    }
                });
            }
        }).start();
    }

    private void endClear(boolean ok) {
        String toastText;
        if (ok) {
            toastText = "清除数据成功";
            setPkgSize(0, 0);
        } else {
            toastText = "清除数据失败";
        }

        // 防止窗口关闭, 网络延迟
        if (null != mContext) {
            Toast.makeText(mContext, toastText, Toast.LENGTH_LONG).show();
        }

        isClearing = false;
        if (null != uploadDialog) {
            uploadDialog.dismiss();
        }
    }
}
