package com.excelliance.open.floatwindow;

import android.app.Activity;
import android.app.Dialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.excelliance.lbui.R;
import com.excelliance.open.BwbxUI;
import com.excelliance.open.CustomDialog;
import com.excelliance.open.PreferencesHelper;

public class ProgressFloatWindow extends BaseFloatWindow {
    public static final String TAG = "ProgressFloatWindow";
    private static int mProgress = 0;
    private ImageView mFloatDownloadIc;
    private TextView mProgressTv;
    private ProgressBar mDialogProgressBar;
    private TextView mDialogProgressMessageTv;
    private CustomDialog mDownloadingDialog;
    private String mRemainSizeStr = null;
    private static long mRemainSize = 0;
    private static boolean mIsDownloading = true;
    private Bitmap mDownloadIc;
    private Bitmap mPauseIc;

    public ProgressFloatWindow(Context context, Activity activity) {
        super(context,activity);
        mContext = context;
    }

    @Override
    protected View getLogoView(LayoutInflater inflater) {
        Resources res = BwbxUI.getResources(mContext);
        XmlResourceParser parser = res.getLayout(R.layout.lebian_float_window);
        View view = inflater.inflate(parser, null);
        view.setLayoutParams(new RelativeLayout.LayoutParams(dp2Px(65,mContext),dp2Px(65,mContext)));
        Drawable d = res.getDrawable(R.drawable.lebian_float_background);
        view.setBackgroundDrawable(d);
        mProgressTv = view.findViewById(R.id.lebian_float_progress_text);
        mFloatDownloadIc = view.findViewById(R.id.lebian_download_ic);
        mDownloadIc = BitmapFactory.decodeResource(res, R.drawable.lebian_float_download);
        mPauseIc = BitmapFactory.decodeResource(res, R.drawable.lebian_float_pause);
        if (mIsDownloading){
            mFloatDownloadIc.setImageBitmap(mDownloadIc);
        }else {
            mFloatDownloadIc.setImageBitmap(mPauseIc);
        }
        return view;
    }

    @Override
    protected void doOpen() {
        showDownloadingDialog(true);
    }

    public void setProgress(int progress){
        if (mContext != null) {
            if (progress != mProgress) {
                mProgress = progress;
                PreferencesHelper.putInt(mContext, PreferencesHelper.MODULE_DLOADINFO, "downloaded_size_float_progress", progress);
            }
            mProgressTv.setText(mProgress + "%");
            if (mDialogProgressBar != null) {
                mDialogProgressBar.setProgress(mProgress);
            }
        }
    }

    public void setRemainSize(long size) {
        if (mContext != null) {
            String str = null;
            Resources res = BwbxUI.getResources(mContext);
            if (size == 0){
                str = res.getString(R.string.lebian_download_float_message_computing);
            }else{
                str = res.getString(R.string.lebian_download_float_message);
            }
            mRemainSize = size;
            mRemainSizeStr = str;
            PreferencesHelper.putLong(mContext, PreferencesHelper.MODULE_DLOADINFO, "downloaded_size_float_win", size);
            if (mDialogProgressMessageTv != null) {
                mDialogProgressMessageTv.setText(String.format(mRemainSizeStr == null?str:mRemainSizeStr, ((double) mRemainSize) / (1024.00 * 1024.00)));
            }
        }
    }

    @Override
    public void show() {
        super.show();
        mProgress = PreferencesHelper.getInt(mContext, PreferencesHelper.MODULE_DLOADINFO, "downloaded_size_float_progress", 0);
        setProgress(mProgress);
    }

    public void destroy() {
        mDialogProgressBar = null;
        mDownloadingDialog = null;
        mActivity = null;
        mContext = null;
    }

    private void showDownloadingDialog(final boolean show) {
        if (mDownloadingDialog == null) {
            Resources res = BwbxUI.getResources(mContext);
            CustomDialog.Builder builder = new CustomDialog.Builder(mContext, mActivity);
            XmlResourceParser parser = res.getLayout(R.layout.lebian_float_dl_progress_view);
            LayoutInflater dialogInflater = LayoutInflater.from(mContext);
            View view = dialogInflater.inflate(parser, null);
            mDialogProgressBar = view.findViewById(R.id.lebian_float_dl_progress_bar);
            Drawable progressDrawable = res.getDrawable(R.drawable.lebian_barcolor);
            mDialogProgressBar.setProgressDrawable(progressDrawable);
            mDialogProgressBar.setProgress(mProgress);
            mDialogProgressMessageTv = view.findViewById(R.id.lebian_float_dl_message);
            String str = res.getString(R.string.lebian_download_float_message_computing);;
            mDialogProgressMessageTv.setText(String.format(mRemainSizeStr == null?str:mRemainSizeStr, ((double) mRemainSize) / (1024.00 * 1024.00)));
            builder.setContentView(view);
            builder.setTitle(res.getString(R.string.lebian_hint));
            final String continueStr = res.getString(R.string.lebian_download_continue);
            final String pauseStr = res.getString(R.string.lebian_download_pause);
            String minimizeStr = res.getString(R.string.lebian_download_float_minimize);
            String negativeButtonText;
            if (mIsDownloading){
                negativeButtonText = pauseStr;
            }else {
                negativeButtonText = continueStr;
            }
            builder.setNegativeButton(negativeButtonText, new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    Intent intent = new Intent(getPackageName() + BwbxUI.getString(mContext, "ACTION_DOWNLOAD_CONTROL", ""));
                    intent.putExtra("control", mIsDownloading);
                    sendBroadcast(mContext, intent);
                    mIsDownloading = !mIsDownloading;
                    if (mIsDownloading){
                        mDownloadingDialog.seNegativeButtonText(pauseStr);
                        mFloatDownloadIc.setImageBitmap(mDownloadIc);
                    }else {
                        mDownloadingDialog.seNegativeButtonText(continueStr);
                        mFloatDownloadIc.setImageBitmap(mPauseIc);
                    }
                }
            });

            builder.setPositiveButton(minimizeStr, new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });


            mDownloadingDialog = builder.create();
            mDownloadingDialog.setCancelable(false);
            mDownloadingDialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
                @Override
                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event){
                    if (keyCode == KeyEvent.KEYCODE_SEARCH){
                        return true;
                    }else{
                        return false;
                    }
                }
            });
        }

        if(!mDownloadingDialog.isShowing() && show) {
            mDownloadingDialog.show();
        }

    }

    private String getPackageName(){
        return mContext.getPackageName();
    }

    @Override
    public void dismiss() {
        super.dismiss();
        if (mDownloadingDialog != null && mDownloadingDialog.isShowing()){
            mDownloadingDialog.dismiss();
        }
    }

    private void sendBroadcast(Context context, Intent intent) {
        intent.setPackage(context.getPackageName());
        context.sendBroadcast(intent);
    }
}
