package com.excelliance.open.custom;

/**
 * 下载界面回调
 */
public class CustomNextChapterCallback {

    /**
     * 下载开始
     * @param resType 下载类型，1.热更新下载 2.分包资源下载
     * @param numerator 可能有多个部分内容一般为 1/2 2/2
     */
    public void onDownloadStart(int resType, String numerator) {
    }

    /**
     * 下载进度
     * @param resType 下载类型，1.热更新下载 2.分包资源下载
     * @param progress 进度
     */
    public void onDownloadProgress(int resType,int progress) {
    }

    /**
     * 下载大小
     * @param downloaded 下载大小
     * @param total 总大小
     */
    public void onDownloadSize(long downloaded, long total) {
    }

    /**
     * 下载速度
     * @param speed kb/s
     */
    public void onDownloadSpeed(float speed) {
    }

    /**
     * 下载完成,一般老用户等一次下载资源的时候会回调，会在解压后回调
     * @param resType 下载类型，1.热更新下载 2.分包资源下载
     */
    public void onDownloadFinish(int resType) {
    }

    /**
     * 解压开始
     * @param resType 下载类型，1.热更新下载 2.分包资源下载
     * @deprecated 已废弃，请使用{@link #onDownloadStart(int, String)}替代
     */
    public void onExtractStart(int resType) {
    }
    /**
     * 解压开始
     * @param resType 下载类型，1.热更新下载 2.分包资源下载
     * @param numerator 可能有多个部分内容一般为 1/2 2/2
     */
    public void onExtractStart(int resType, String numerator) {
    }

    /**
     * 解压进度
     * @param resType 下载类型，1.热更新下载 2.分包资源下载
     * @param progress 进度
     */
    public void onExtractProgress(int resType, float progress) {

    }

    /**
     * 解压完成
     * @param resType 下载类型，1.热更新下载 2.分包资源下载
     */
    public void onExtractFinish(int resType) {

    }

    /**
     * 资源更新-开始计算压缩包md5
     * @param resType 下载类型，1 热更
     */
    public void onComputeMD5Start(int resType){

    }
    /**
     * 资源更新-计算压缩包md5进度
     * @param resType 下载类型，1 热更
     * @param progress 进度
     */
    public void onComputeMD5Progress(int resType, float progress){

    }
    /**
     * 资源更新-计算压缩包md5完成
     * @param resType 下载类型，1 热更
     */
    public void onComputeMD5Finish(int resType){

    }

    /**
     * 错误
     * @param errorCode 可以查看{@link com.excelliance.assetsonly.library.ErrorCode}
     * @param errorMsg
     *
     *
     */
    public void onError(int errorCode, String errorMsg) {

    }
}
