package com.excelliance.open;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;

import com.excelliance.open.library.LBDnsListener;
import com.excelliance.open.library.PromptActivityInterface;
import com.excelliance.open.library.PromptDialogListener;

import java.lang.reflect.Constructor;

public class PromptHelper extends BaseUIHelper{

    private static final String TAG = "PromptHelper";

    private PromptActivityInterface mPromptImpl;

    public PromptHelper(Activity mActivity) {
        super(mActivity);
    }

    public void init(Handler handler, Intent intent, PromptDialogListener self) {
        mPromptImpl = getPromptImpl();
        if (mPromptImpl != null) {
            mPromptImpl.init(self, handler, intent);
        }else{
            mMode = MODE.TEST;
        }
    }

    private PromptActivityInterface getPromptImpl() {
        PromptActivityInterface obj = null;
        try {
            Class clazz = getClass("main.ui.PromptActivityImpl");
            Constructor cons = clazz.getDeclaredConstructor();
            cons.setAccessible(true);
            obj = (PromptActivityInterface) cons.newInstance();
        } catch (Exception e) {
            Log.d(TAG, "no PromptActivityImpl");
            e.printStackTrace();
        }

        return obj;
    }

    public void prepareViewFinished() {
        if (mPromptImpl != null) {
            mPromptImpl.prepareViewFinished();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        try {
            if (mPromptImpl != null) {
                mPromptImpl.onCreate(savedInstanceState);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void onResume() {
        try {
            if (mPromptImpl != null) {
                mPromptImpl.onResume();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void onPause() {
        try {
            if (mPromptImpl != null) {
                mPromptImpl.onPause();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }


    public void onStop() {
        try {
            if (mPromptImpl != null) {
                mPromptImpl.onStop();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void onDestroy() {
        try {
            if (mPromptImpl != null) {
                mPromptImpl.onDestroy();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean ret = false;
        try {
            if (mPromptImpl != null) {
                ret = mPromptImpl.onKeyDown(keyCode,event);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        return ret;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        try {
            if (mPromptImpl != null) {
                mPromptImpl.onConfigurationChanged(newConfig);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void onNewIntent(Intent intent) {
        try {
            if (mPromptImpl != null) {
                mPromptImpl.onNewIntent(intent);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }
}
