package com.excelliance.open;

import android.content.Context;

import java.lang.reflect.Method;
import java.util.Map;

/**
 * Created by tukai on 2018-02-27.
 */

public class PreferencesHelper {
    public static final String TAG = "PreferencesHelper";

    public static final String MODULE_HU = "lebian_module_hu";
    public static final String MODULE_BWBXINFO = "lebian_module_bwbxinfo";
    public static final String MODULE_USERINFO = "lebian_module_userinfo";
    public static final String MODULE_EXTRACTINFO = "lebian_module_extractinfo";
    public static final String MODULE_QUERYINFO = "lebian_module_queryinfo";
    public static final String MODULE_GAMEINFO = "lebian_module_gameinfo";
    public static final String MODULE_DLOADERROR = "lebian_module_dloaderror";
    public static final String MODULE_PROMPT = "lebian_module_prompt";
    public static final String MODULE_BASE = "lebian_module_base";
    public static final String MODULE_DOMAIN = "lebian_module_domain";
    public static final String MODULE_MD5INFO = "lebian_module_md5info";
    public static final String MODULE_OVERLAYINFO = "lebian_module_overlayinfo";
    public static final String MODULE_DLOADINFO = "lebian_module_dloadinfo";
    public static final String MODULE_CRASH = "lebian_module_crash";
    public static final String MODULE_UPDATEINFO = "lebian_module_updateinfo";
    public static final String MODULE_BWBXDLOADER_MULTI_THREAD = "lebian_module_bwbxdloader_multi_thread";
    public static final String MODULE_DLOADCOM_MULTI_THREAD1 = "lebian_module_dloadcom_multi_thread1";
    public static final String MODULE_DLOADCOM_MULTI_THREAD2 = "lebian_module_dloadcom_multi_thread2";
    public static final String MODULE_DLOADCOM_SINGLE_THREAD1 = "lebian_module_dloadcom_single_thread1";
    public static final String MODULE_DLOADCOM_SINGLE_THREAD2 = "lebian_module_dloadcom_single_thread2";
    public static final String MODULE_ABTEST = "lebian_module_abtest";
    public static final String MODULE_GLOBAL_SETTINGS = "lebian_module_global_settings";

    /**
     * 设置可被多个进程共享的Boolean值
     */
    public static void putBoolean(final Context context, final String module, final String key, final boolean value) {
        try {
            Class<?> preferencesHelper = BwbxUI.getClass("preferences.PreferencesHelper", false, context.getClassLoader());
            Method putBoolean = preferencesHelper.getDeclaredMethod("putBoolean", new Class[] {Context.class, String.class, String.class, boolean.class});
            putBoolean.setAccessible(true);
            putBoolean.invoke(null, new Object[]{(Context)context, (String)module, (String)key, (boolean)value});
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 设置可被多个进程共享的Int值
     */
    public static void putInt(final Context context, final String module, final String key, final int value) {
        try {
            Class<?> preferencesHelper = BwbxUI.getClass("preferences.PreferencesHelper", false, context.getClassLoader());
            Method putInt = preferencesHelper.getDeclaredMethod("putInt", new Class[] {Context.class, String.class, String.class, int.class});
            putInt.setAccessible(true);
            putInt.invoke(null, new Object[]{(Context)context, (String)module, (String)key, (int)value});
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 设置可被多个进程共享的Long值
     */
    public static void putLong(final Context context, final String module, final String key, final long value) {
        try {
            Class<?> preferencesHelper = BwbxUI.getClass("preferences.PreferencesHelper", false, context.getClassLoader());
            Method putLong = preferencesHelper.getDeclaredMethod("putLong", new Class[] {Context.class, String.class, String.class, long.class});
            putLong.setAccessible(true);
            putLong.invoke(null, new Object[]{(Context)context, (String)module, (String)key, (long)value});
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 设置可被多个进程共享的String值
     */
    public static void putString(final Context context, final String module, final String key, final String value) {
        try {
            Class<?> preferencesHelper = BwbxUI.getClass("preferences.PreferencesHelper", false, context.getClassLoader());
            Method putString = preferencesHelper.getDeclaredMethod("putString", new Class[] {Context.class, String.class, String.class, String.class});
            putString.setAccessible(true);
            putString.invoke(null, new Object[]{(Context)context, (String)module, (String)key, (String)value});
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取可被多个进程共享的Boolean值,若key不存在,则返回defaultValue
     */
    public static boolean getBoolean(final Context context, final String module, final String key, final boolean defaultValue) {
        boolean ret = defaultValue;
        try {
            Class<?> preferencesHelper = BwbxUI.getClass("preferences.PreferencesHelper", false, context.getClassLoader());
            Method getBoolean = preferencesHelper.getDeclaredMethod("getBoolean", new Class[] {Context.class, String.class, String.class, boolean.class});
            getBoolean.setAccessible(true);
            ret = (Boolean) getBoolean.invoke(null, new Object[]{(Context)context, (String)module, (String)key, (boolean)defaultValue});
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }


    /**
     * 获取可被多个进程共享的Int值,若key不存在,则返回defaultValue
     */
    public static int getInt(final Context context, final String module, final String key, final int defaultValue) {
        int ret = defaultValue;
        try {
            Class<?> preferencesHelper = BwbxUI.getClass("preferences.PreferencesHelper", false, context.getClassLoader());
            Method getInt = preferencesHelper.getDeclaredMethod("getInt", new Class[] {Context.class, String.class, String.class, int.class});
            getInt.setAccessible(true);
            ret = (Integer) getInt.invoke(null, new Object[]{(Context)context, (String)module, (String)key, (int)defaultValue});
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    /**
     * 获取可被多个进程共享的Long值,若key不存在,则返回defaultValue
     */
    public static long getLong(final Context context, final String module, final String key, final long defaultValue) {
        long ret = defaultValue;
        try {
            Class<?> preferencesHelper = BwbxUI.getClass("preferences.PreferencesHelper", false, context.getClassLoader());
            Method getLong = preferencesHelper.getDeclaredMethod("getLong", new Class[] {Context.class, String.class, String.class, long.class});
            getLong.setAccessible(true);
            ret = (Long) getLong.invoke(null, new Object[]{(Context)context, (String)module, (String)key, (long)defaultValue});
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    /**
     * 获取可被多个进程共享的Int值,若key不存在,则返回defaultValue
     */
    public static String getString(final Context context, final String module, final String key, final String defaultValue) {
        String ret = defaultValue;
        try {
            Class<?> preferencesHelper = BwbxUI.getClass("preferences.PreferencesHelper", false, context.getClassLoader());
            Method getString = preferencesHelper.getDeclaredMethod("getString", new Class[] {Context.class, String.class, String.class, String.class});
            getString.setAccessible(true);
            ret = (String) getString.invoke(null, new Object[]{(Context)context, (String)module, (String)key, (String)defaultValue});
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    /**
     * 获取所有配置
     */
    public static Map<String, String> getAll(final Context context, final String module) {
        Map<String, String> ret = null;
        try {
            Class<?> preferencesHelper = BwbxUI.getClass("preferences.PreferencesHelper", false, context.getClassLoader());
            Method getSize = preferencesHelper.getDeclaredMethod("getAll", new Class[] {Context.class, String.class});
            getSize.setAccessible(true);
            ret = (Map) getSize.invoke(null, new Object[]{(Context)context, (String)module});
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void remove(final Context context, final String module, final String key) {
        try {
            Class<?> preferencesHelper = BwbxUI.getClass("preferences.PreferencesHelper", false, context.getClassLoader());
            Method remove = preferencesHelper.getDeclaredMethod("remove", new Class[] {Context.class, String.class, String.class});
            remove.setAccessible(true);
            remove.invoke(null, new Object[]{(Context)context, (String)module, (String)key});
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 清除配置文件
     */
    public static void clear(final Context context, final String module) {
        try {
            Class<?> preferencesHelper = BwbxUI.getClass("preferences.PreferencesHelper", false, context.getClassLoader());
            Method clear = preferencesHelper.getDeclaredMethod("clear", new Class[] {Context.class, String.class});
            clear.setAccessible(true);
            clear.invoke(null, new Object[]{(Context)context, (String)module});
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
