package com.excelliance.open;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.widget.Toast;

import com.excelliance.open.library.DialogClickCallback;
import com.excelliance.open.library.PromptDialogListener;
import com.excelliance.lbui.R;

public class NewPromptActivity extends BaseActivity implements PromptDialogListener {
    private PromptHelper mPromptHelper;
    private Handler mHandler;
    private UIDialogManager mUIDialogManager;

    @Override
    public int getLBTheme() {
        return R.style.LebianPromptTheme;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        mPromptHelper = new PromptHelper(this);
        mPromptHelper.windowConfigs();
        super.onCreate(savedInstanceState);
        mPromptHelper.setScreenOrientation();
        mHandler = new Handler();
        mUIDialogManager = new UIDialogManager(this);
        mPromptHelper.init(mHandler,getIntent(),this);
        mPromptHelper.onCreate(savedInstanceState);
        new DialogSimulator(getIntent(),mPromptHelper.isTestMode(), this);
    }

    @Override
    protected void onResume() {
        super.onResume();
        mPromptHelper.onResume();
    }

    @Override
    protected void onStop() {
        super.onStop();
        mPromptHelper.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mPromptHelper.onDestroy();
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        mPromptHelper.onNewIntent(intent);
    }

    @Override
    public void onShowDialog(int type, Bundle params, DialogClickCallback dialogClickCallback) {
        mUIDialogManager.show(type,params,dialogClickCallback);
    }

    @Override
    public void onToast(int i, Bundle bundle) {
        String toastStr = getString(R.string.lebian_download_success);
        Toast.makeText(this, toastStr, Toast.LENGTH_SHORT).show();
        mHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                finish(); //延迟finish，不然toast会很快消失
            }
        }, 1000);
    }

    private static class DialogSimulator {
        private static final String TAG = "DialogSimulator";
        public DialogSimulator(Intent intent,boolean isTestMode, final NewPromptActivity activity) {
            Log.d(TAG, "ProgressSimulator test mode = " + isTestMode);
            if (isTestMode){
                boolean dataConnection = intent.getBooleanExtra("dataConnection", false);
                boolean forceUpdate = intent.getBooleanExtra("forceUpdate",false);
                long size = intent.getLongExtra("size",0L);
                Bundle params = new Bundle();
                params.putBoolean("forceUpdate", forceUpdate);
                params.putBoolean("dataConnection", dataConnection);
                params.putLong("size", size);
                activity.onShowDialog(intent.getIntExtra("dialogtype", 1), params, new DialogClickCallback() {
                    @Override
                    public void onPositiveClick(int i, Bundle bundle) {
                        activity.finish();
                    }

                    @Override
                    public void onNegativeClick(int i, Bundle bundle) {
                        activity.finish();
                    }

                    @Override
                    public void onCheckBox(int i, Bundle bundle, boolean b) {

                    }

                    @Override
                    public void dismiss() {
                        activity.finish();
                    }
                });
            }
        }
    }
}
