package com.excelliance.open;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;

import com.excelliance.open.library.BwbxUIListener;
import com.excelliance.open.library.DialogClickCallback;
import com.excelliance.open.floatwindow.ProgressFloatWindow;
import com.excelliance.open.floatwindow.RecordFloatWindow;

import java.util.HashMap;

public class NewBwbxUI implements BwbxUIListener {

    private BwbxUIHelper mBwbxUIHelper;
    private UIDialogManager mUIDialogManager;
    private ProgressFloatWindow mProgressFloatWindow;

    /**
     * 记录悬浮框与activity的映射表
     */
    private HashMap<Activity, RecordFloatWindow> mRecordActivityFloatMap = new HashMap<>();

    /**
     * 表示当前展示的悬浮框
     */
    private RecordFloatWindow mRecordFloatWindow;
    private int mRecordCount;
    private long mRecordSize;

    /**
     * 是否是记录模式
     */
    private boolean mIsRecord;
    
    private Context mContext;

    public NewBwbxUI(Context context) {
        mContext = context;
        mBwbxUIHelper = new BwbxUIHelper(context);
        mUIDialogManager = new UIDialogManager(context);
    }

    public void init(Application app, boolean isRecode) {
        mBwbxUIHelper.init(app,isRecode,this);
        mIsRecord = isRecode;
        if (isRecode) {
            mRecordActivityFloatMap = new HashMap<>();
        }
    }

    @Override
    public void onShowDialog(int type, Bundle params, Activity activity, boolean show, DialogClickCallback callback) {
        mUIDialogManager.show(type,show,activity,params,callback);
    }

    @Override
    public void onProgress(int progress, long size) {
        //下载进度 下载大小
    }

    @Override
    public void onRecord(int count, long size) {
        mRecordCount = count;
        mRecordSize = size;
        RecordFloatWindow floatWindow = mRecordFloatWindow;
        if (null != floatWindow) {
            floatWindow.setPkgSize(count, size);
        }
    }

    @Override
    public void onFloatProgressChange(int progress, long size) {
        if (null == mProgressFloatWindow) {
            return;
        }
        if (progress > 0)
            mProgressFloatWindow.setProgress(progress);
        mProgressFloatWindow.setRemainSize(size);
    }

    @Override
    public void onNetworkChange(boolean isWifi) {

    }

    @Override
    public void onFloatWindowShow(Activity activity) {
        RecordFloatWindow floatWindow = mRecordActivityFloatMap.get(activity);
        if (null != floatWindow) {
            floatWindow.setPkgSize(mRecordCount, mRecordSize);
            floatWindow.show();
            mRecordFloatWindow = floatWindow;
        }
    }

    @Override
    public void onFloatWindowDismiss(Activity activity) {
        RecordFloatWindow floatWindow = mRecordActivityFloatMap.get(activity);
        if (null != floatWindow) {
            floatWindow.dismiss();
        }
    }

    private void onActivityCreated(Activity activity) {
        if (mIsRecord) {
            RecordFloatWindow floatWindow = mRecordActivityFloatMap.get(activity);
            if (null == floatWindow) {
                floatWindow = new RecordFloatWindow(mContext, activity);
                mRecordActivityFloatMap.put(activity, floatWindow);
            }
        }

    }

    private void onActivityDestroyed(Activity activity) {
        if (mIsRecord) {
            RecordFloatWindow floatWindow = mRecordActivityFloatMap.get(activity);
            if (null != floatWindow) {
                floatWindow.dismiss();
                floatWindow.destroy();
                mRecordActivityFloatMap.remove(activity);
            }
        }
    }

    @Override
    public void onProgressWindowShow(Activity activity) {
        if (null != mProgressFloatWindow) {
            mProgressFloatWindow.dismiss();
            mProgressFloatWindow.destroy();
        }
        mProgressFloatWindow = new ProgressFloatWindow(mContext, activity);
        mProgressFloatWindow.show();
    }

    @Override
    public void onProgressWindowDismiss(Activity activity) {
        if (mProgressFloatWindow != null) {
            mProgressFloatWindow.dismiss();
            mProgressFloatWindow.destroy();
            mProgressFloatWindow = null;
        }
    }

    @Override
    public void onFloatWindowCreate(Activity activity) {
        if (mIsRecord) {
            RecordFloatWindow floatWindow = mRecordActivityFloatMap.get(activity);
            if (null == floatWindow) {
                floatWindow = new RecordFloatWindow(mContext, activity);
                mRecordActivityFloatMap.put(activity, floatWindow);
            }
        }
    }

    @Override
    public void onFloatWindowDestroy(Activity activity) {
        if (mIsRecord) {
            RecordFloatWindow floatWindow = mRecordActivityFloatMap.get(activity);
            if (null != floatWindow) {
                floatWindow.dismiss();
                floatWindow.destroy();
                mRecordActivityFloatMap.remove(activity);
            }
        }
    }
}


