package com.excelliance.open;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;

import java.lang.ref.WeakReference;

/**
 * 用来获取当前window信息的类
 */
public class LbUiWindowManager {
    private static LbUiWindowManager mLbUiWindowManager;
    private WeakReference<Context> mContextWeakReference;
    private WindowManager mWindowManager;
    private int mScreenWidth;
    private int mScreenHeight;

    private LbUiWindowManager(Context context) {
        mWindowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        if (mWindowManager != null && mScreenWidth == 0 && mScreenHeight == 0) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                mWindowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
                mScreenWidth = displayMetrics.widthPixels;
                mScreenHeight = displayMetrics.heightPixels;
            } else {
                mScreenWidth = mWindowManager.getDefaultDisplay().getWidth();
                mScreenHeight = mWindowManager.getDefaultDisplay().getHeight();
            }
        }
    }

    public static LbUiWindowManager getInstance(Context context) {
        if (mLbUiWindowManager == null) {
            synchronized (LbUiWindowManager.class) {
                if (mLbUiWindowManager == null) {
                    mLbUiWindowManager = new LbUiWindowManager(context);
                }
            }
        }
        return mLbUiWindowManager;
    }

    public static void remove(){
        mLbUiWindowManager = null;
    }

    /**
     * 获取当前窗口的宽度。
     *
     * @return 窗口宽度
     */
    public int getScreenWidth() {
        return mScreenWidth;
    }

    /**
     * 获取当前窗口高度
     *
     * @return 窗口高度
     */
    public int getScreenHeight() {
        return mScreenHeight;
    }
}
