package com.excelliance.open;

import android.app.Activity;
import android.app.Application;
import android.content.Context;

import com.excelliance.open.library.BwbxUIListener;

/**
 * 其它module调用lbui.jar时, 提供统一反射调用入口
 */
public class LBSdkHelper {

    private static final String TAG = "LBSdkHelper";
    private static Application sAttachApplication;
    private static Context sAttachContext;
    private static NewBwbxUI sNewBwbxUI;


    public static BwbxUIListener getUIListener() {
        return sNewBwbxUI;
    }

    static NewBwbxUI onCreate(Activity activity) {
        sNewBwbxUI = new NewBwbxUI(activity.getApplicationContext());
        return sNewBwbxUI;
    }

    static void onDestroy(Activity activity) {
        sNewBwbxUI = null;
    }

    public static void attachApplication(Application application) {
        sAttachApplication = application;
    }

    /**
     * 生命周期函数, {@link android.app.Application#attachBaseContext(Context)}
     * @param base 上下文
     */
    public static void attachBaseContext(Context base) {
        sAttachContext = base;
    }

    /**
     * 生命周期函数, 在{@link #attachBaseContext(Context)} 之后调用
     * @param isRecord 是否记录模式
     */
    public static void initialize(boolean isRecord) {
        NewBwbxUI newBwbxUI = new NewBwbxUI(sAttachContext);
        newBwbxUI.init(sAttachApplication, isRecord);
        sNewBwbxUI = newBwbxUI;
    }
}
