package com.excelliance.open;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class CustomInflaterFactory implements LayoutInflater.Factory {

    private LayoutInflater.Factory mBaseFactory;
    private ClassLoader mClassLoader;

    public CustomInflaterFactory(LayoutInflater.Factory base, ClassLoader classLoader) {
        if (null == classLoader) {
            throw new IllegalArgumentException("classLoader is null");
        }
        mBaseFactory = base;
        mClassLoader = classLoader;
    }

    @Override
    public View onCreateView(String s, Context context, AttributeSet attributeSet) {
        View v = null;
        try {
            Class<?> clazz = mClassLoader.loadClass(s);
            Constructor c = clazz.getConstructor(Context.class, AttributeSet.class);
            v = (View) c.newInstance(context, attributeSet);
        } catch (Exception e) {

        }
        return v != null ? v : (mBaseFactory != null ? mBaseFactory.onCreateView(s, context, attributeSet) : null);
    }
}
