package com.excelliance.open;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;

import com.excelliance.open.library.BwbxUIInterface;
import com.excelliance.open.library.BwbxUIListener;
import com.excelliance.open.library.PromptActivityInterface;
import com.excelliance.open.library.PromptDialogListener;

import java.lang.reflect.Constructor;

public class BwbxUIHelper extends BaseUIHelper{
    private static final String TAG = "BwbxUIHelper";

    private BwbxUIInterface mBwbxUIImpl;

    public BwbxUIHelper(Context context) {
        mBwbxUIImpl = getBwbxUIImpl();
        if (mBwbxUIImpl != null) {
            mBwbxUIImpl.create(context);
        } else {
            mMode = MODE.TEST;
        }
    }

    public void init(Application application, boolean isRecord, BwbxUIListener self) {
        try {
            if (mBwbxUIImpl != null) {
                mBwbxUIImpl.init(application,isRecord,self);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private BwbxUIInterface getBwbxUIImpl() {
        BwbxUIInterface obj = null;
        try {
            Class clazz = getClass("main.ui.BwbxUIImpl");
            Constructor cons = clazz.getDeclaredConstructor();
            cons.setAccessible(true);
            obj = (BwbxUIInterface) cons.newInstance();
        } catch (Exception e) {
            Log.d(TAG, "no BwbxUIImpl");
            e.printStackTrace();
        }

        return obj;
    }
}
