package com.excelliance.open;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BaseUIHelper {
    public static final String TAG = "BaseUIHelper";
    enum MODE {TEST,LBUI}//测试模式，正常使用LBUI
    protected MODE mMode = MODE.LBUI;
    private Activity mActivity;

    public BaseUIHelper() {

    }

    public BaseUIHelper(Activity mActivity) {
        this.mActivity = mActivity;
    }

    public boolean isTestMode(){
        return mMode == MODE.TEST;
    }

    public boolean isUIMode(){
        return mMode == MODE.LBUI;
    }

    public static int dip2px(Context context, float dpValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * scale + 0.5f);
    }

    protected Class<?> getClass(String name) {
        Class<?> cls = null;
        try {
            cls = Class.forName("com.excelliance.assetsonly." + name);
        } catch (Exception e) {
            try {
                cls = Class.forName("com.excelliance.lebian." + name);
            } catch (Exception e1) {
                try {
                    cls = Class.forName("com.excelliance.assetsonly." + name);
                } catch (Exception e2) {
                }
            }
        }
        return cls;
    }

    public static Class<?> getClass(String name, boolean initialize, ClassLoader loader) {
        Class<?> cls = null;
        try {
            cls = Class.forName("com.excelliance.assetsonly." + name, initialize, loader);
        } catch (Exception e) {
            try {
                cls = Class.forName("com.excelliance.lebian." + name, initialize, loader);
            } catch (Exception e1) {
                try {
                    cls = Class.forName("com.excelliance.assetsonly." + name, initialize, loader);
                } catch (Exception e2) {
                }
            }
        }
        return cls;
    }

    @SuppressLint("WrongConstant")
    public void windowConfigs() {
        if (mActivity != null) {
            mActivity.getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_LAYOUT_STABLE);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
                WindowManager.LayoutParams lp = mActivity.getWindow().getAttributes();
                lp.layoutInDisplayCutoutMode = WindowManager.LayoutParams.LAYOUT_IN_DISPLAY_CUTOUT_MODE_SHORT_EDGES;
                mActivity.getWindow().setAttributes(lp);
            }
            mActivity.getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        }
    }

    public void setOrientation(Intent intent) {
        if (isTestMode() && mActivity != null) {
            int orientation = intent.getIntExtra("orientation", 0);
            mActivity.setRequestedOrientation(orientation);
        }
    }

    public static Resources getResources(Context context) {
        Resources res = null;
        try {
            Class<?> networkUtil = getClass("main.PlatformResources", false, context.getClassLoader());
            Method getRes = networkUtil.getDeclaredMethod("getMainResources", Context.class);
            getRes.setAccessible(true);
            res = (Resources) getRes.invoke(null, context);
        } catch (Exception e) {
            Log.d(TAG, "getResources err:"+e);
            res = context.getResources();
        }
        Log.d(TAG, "getResources res:"+res);
        return res;
    }

    public static Resources getApkResources(Context context) {
        Resources res = null;
        try {
            Class<?> networkUtil = getClass("main.PlatformResources", false, context.getClassLoader());
            Method getRes = networkUtil.getDeclaredMethod("getApkResources", Context.class);
            getRes.setAccessible(true);
            res = (Resources) getRes.invoke(null, context);
        } catch (Exception e) {
            Log.d(TAG, "getResources err:"+e);
            res = context.getResources();
        }
        Log.d(TAG, "getResources res:"+res);
        return res;
    }

    public static boolean getGlobalBoolean(Context context, String key, boolean defVal) {
        boolean ret = defVal;
        try {
            Class<?> clazz = Class.forName("com.excelliance.open.GlobalSettings", false, context.getClassLoader());
            Field f = clazz.getDeclaredField(key);
            ret = f.getBoolean(null);
        } catch (Exception e) {
            e.printStackTrace();
        }
        ret = PreferencesHelper.getBoolean(context, PreferencesHelper.MODULE_GLOBAL_SETTINGS, key, ret);
        return ret;
    }

    public void setScreenOrientation(){
        //android8.0 如果是透明Window 设置方向会报错  其他版本无问题
        if(Build.VERSION.SDK_INT == Build.VERSION_CODES.O){
            return;
        }
        PackageManager packageManager = mActivity.getPackageManager();
        Intent intent = packageManager.getLaunchIntentForPackage(mActivity.getPackageName());
        ComponentName comp = intent.getComponent();
        ActivityInfo activityInfo = null;
        try {
            activityInfo = packageManager.getActivityInfo(comp, PackageManager.MATCH_DEFAULT_ONLY);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        int orientation = activityInfo.screenOrientation;
        if(orientation == -1){
            orientation = mActivity.getApplicationContext().getResources().getConfiguration().orientation;
        }
        mActivity.setRequestedOrientation(orientation);
    }

}
