package com.excelliance.open;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;

import com.excelliance.lbui.R;

public class AdaptiveProgressBar extends ProgressBar {

    private LbUiWindowManager mLbUiWindowManager;
    //宽度比例
    private double mWidthScale = 0.92;
    //高度绝对值，单位dp
    private int mHeightdp = 10;
    private int mHeight = 1;
    private Context mContext;

    private OnProgressChangeListener listener;

    public interface OnProgressChangeListener {
        void onProgressChanged(int progress);
    }


    public AdaptiveProgressBar(Context context) {
        this(context, null);
    }

    public AdaptiveProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        mLbUiWindowManager = LbUiWindowManager.getInstance(context);
        mContext = context;
        Drawable progressDrawable = context.getResources().getDrawable(R.drawable.lebian_barcolor);
        setProgressDrawable(progressDrawable);
        mHeight = dip2px(context, mHeightdp);
    }

    public void setOnProgressChangeListener(OnProgressChangeListener listener) {
        this.listener = listener;
    }

    @Override
    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        setMeasuredDimension((int) (mLbUiWindowManager.getScreenWidth() * mWidthScale),mHeight);
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * scale + 0.5f);
    }

    @Override
    public synchronized void setProgress(int progress) {
        super.setProgress(progress);
        super.setProgress(progress);
        if (listener != null) {
            listener.onProgressChanged(progress);
        }
    }
}
