package com.excelliance.open;

import android.content.Context;

import com.excelliance.assetsonly.LBConfig;

import java.util.Map;


public class GlobalSettings {
    //注意，所有开关设置全部转移到golbalSettings.xml中，GlobalSettings.java不需要做任何修改
    //指定游戏引擎，默认-1，如果不指定sdk也会自动判断，指定后可以省去自动判断的时间，提升启动速度。1(UNITY);2(COCOS);3(UE4);4(WANMEI);5(UNITY_BIG_ASSET);6(UE3)
    public static int ENGINE;
    //游戏运行区域：0（大陆）;1（海外）;2（台湾，仅限游戏使用）;
    public static int SELECTED_AREA;
    //乐变sdk总开关，false禁用乐变
    public static boolean USE_LEBIAN;
    //使用热更新功能配置为true，否则配置为false
    public static boolean USE_REGENG;
    //若配置为true，有“强制更新”的新版本时，用户选择“退出”，那WiFi下还是会在后台继续下载
    public static boolean DOWNLOAD_AFTER_QUIT;
    //仅资源更新时，更新完是否重启程序，true-重启， false-不重启，默认false
    public static boolean RESTART_NEW_RAW;
    //启动时sdk默认会发起检查。设置为false关闭sdk启动时的默认检查
    public static boolean AUTO_CHECK_NEWVER_ONSTART;
    //使用乐变闪退日志抓取功能
    public static boolean ENABLE_CRASH_REPORT;
    //设置新版本的保存路径：
    //LOCATION_AUTO，当新版本小于50MB，或者sdcard路径以/storage/emulated/0/开头，则保存至data；否则保存至sdcard；
    //LOCATION_SD，优先保存在sdcard；
    //LOCATION_DATA，优先保存至data；
    public static int NEWV_LOCATION;
    //下载提示框显示取消按钮，默认只显示下载按钮
    public static boolean ENABLE_EXIT_BUTTON;
    //使用分包功能设置为true；不使用分包功能设置为false
    public static boolean USE_BWBX;
    //是否使用assetmanager方式加载资源，由乐变修改
    public static boolean HANDLE_ASSETMANAGER_BWBX;
    //碰到缺失资源即时下载资源会显示加载动画，当前是一个咖啡杯动画，
    public static boolean SHOW_LOADING_PROGRESS_BWBX;
    //缺资源后下载时间超过多久会显示加载动画，默认15s
    public static int SHOW_LOADING_AFTER_DOWNLOAD_MISSING_TIME;
    //非wifi网络下，玩家进入游戏会弹出下载提示框，true打开，false关闭
    public static boolean SHOW_FIRST_DIALOG_WITHOUT_WIFI_BWBX;
    //任何网络下，玩家进入游戏都会弹出下载提示框，true打开，false关闭
    public static boolean SHOW_FIRST_DIALOG_ALWAYS_BWBX;
    //自动检查老用户的开关
    public static boolean CHECK_OLD_USER_AUTO;
    //接口控制流量第一个弹框
    public static boolean CONTROL_FIRST_DIALOG_BWBX;
    //老用户判断条件，默认缺失20条资源提示一次性下载所有资源
    public static int OLD_USER_MISSING_CONDITION;
    //如果老用户提示，玩家选择不下载，再次达到条件时，是否还要提示，默认提示3次
    public static int SHOW_OLD_USER_COUNT;
    //二次加载开关，启动游戏立即下载所有资源,只有使用二次加载时设置为true；边玩边下或二次加载+边玩边下均设置为false
    public static boolean CHOOSE_BY_USER_BWBX;
    //如果您想自己调用LebianSdk.twiceLoad控制二次加载时机，则设置为true。
    //如果设置为true，请注意：
    //如果二次加载的是完整资源，请设置streaming_twiceload为true；
    //如果是二次加载+边玩边下，请设置streaming_twiceload为false
    public static boolean TWLOAD_API_CONTROL;
    //二次加载提示只保留一个按钮
    public static boolean CHOOSE_BY_USER_BWBX_FORCE;
    //试玩资源耗尽后，选择下载，直接切换到下载界面，将所有资源一次性下载下来
    public static boolean DOWNLOAD_FULL_AFTER_SECOND_DIALOG_BWBX;
    //网速低于100K/s时，会(true提示,false不提示)用户一次性下载所有资源
    public static boolean SHOW_DIALOG_NETWORK_WEAK_BWBX;
    //wifi网络下显示二次加载下载提示，默认启动游戏直接切到下载界面，如果开启后wifi和流量网络都会提示
    public static boolean SHOW_DIALOG_WITH_WIFI_WHEN_TWLOAD_BWBX;
    // 流量网络下显示二次加载下载提示，默认启动游戏直接切到下载界面
    public static boolean SHOW_DIALOG_WITHOUT_WIFI_WHEN_TWLOAD_BWBX;
    //流量网络启动游戏玩家如果没有选择下载，此开关用来控制多久后提示下载，单位为毫秒，0表示资源耗尽再提示下载
    public static int SECOND_DIALOG_INTERVAL_BWBX;
    //老用户提示只显示下载一个按钮，默认“是”“否”两个按钮
    public static boolean SHOW_DIALOG_BUTTON_BY_OLD_USER;
    //启动游戏在后台二次加载
    public static boolean CHOOSE_BY_USER_BWBX_LATER;
    //streaming_twiceload_later打开的情况，流量网络启动时提示下载
    public static boolean SHOW_DIALOG_WITHOUT_WIFI_WHEN_LBRES_LATER;
    //乐变下载界面使用多张背景图，切换时使用淡入淡出动画
    public static boolean USE_ANIMAL_WHEN_SWITCH_VIEW;
    //wifi网络提示资源差分包下载
    public static boolean SHOW_DIALOG_RESPATCH_IN_WIFI;
    //缺资源加载动画显示下载进度
    public static boolean SHOW_PROGRESS_IN_DOWNLOADING_ANIMATION;
    // 游戏如果会加载解压到本地的资源，需要将此开关打
    public static boolean LOADING_LOCAL_RES;
    //流量网络启动玩家选择了不下载，资源耗尽后，缺失多少资源再提示下载，默认5M
    public static int MISSING_SIZE_LIMIT;
    //悬浮窗开关
    public static boolean SHOW_BWBX_FLOAT_WINDOW;
    //边玩变下下载限速
    public static int BWBX_DOWNLOAD_SPEED_LIMIT;
    //边玩边下多线程下载开关
    public static boolean BWBX_DOWNLOAD_USE_MULTI_THREAD;
    //用户同意隐私政策后再获取隐私信息
    public static boolean AFTER_USER_PERMISSION;
    //严格隐私政策
    public static boolean START_CHECK_PRIVACY_PERMISSION;
    //可玩微端使用
    public static boolean USE_KWWD;

    public static boolean DONT_USE_ACTIVITY_TASK;
    /**
     下载界面的图片采用的缩放模式(默认参数为零)
     0：等比平铺屏幕，多余部分会被剪切
     1：等比缩放，不足的部分会用黑色填充
     2：平铺屏幕，非等比缩放，图片会发生变形
     */
    public static int SCALE_MODE_IN_NEXTCHAPTER;

    public static int USE_HTTP_OR_HTTPS;

    public static void refreshState() {
    }

    /**
     * 解析globalSettings.xml配置文件
     * @param context context
     */
    public static void init(Context context){
    }

    public enum Settings {
        selected_area,use_regeng,use_streaming,streaming_twiceload,download_after_quit,auto_check_newver_onstart,
        newv_location, restart_after_new_raw_success, streaming_handle_assetmanager,streaming_show_loading_progress,streaming_show_loading_after_download_missing_time,
        streaming_show_first_dialog_without_wifi,streaming_show_first_dialog_always,streaming_control_first_dialog,streaming_check_old_user_auto,
        streaming_old_user_missing_condition,streaming_show_old_user_count,streaming_twload_api_control,streaming_twiceload_force,
        streaming_download_full_after_second_dialog,streaming_network_weak,streaming_show_dialog_with_wifi_when_twload,
        streaming_show_dialog_without_wifi_when_twload,streaming_second_dialog_interval,streaming_show_dialog_button_by_old_user,streaming_twiceload_later,
        streaming_show_dialog_without_wifi_when_twiceload_later,streaming_show_dailog_respatch_in_wifi,
        streaming_show_progress_in_downloading_animation,streaming_load_local_res,streaming_missing_size_limit,
        use_lebian,enable_crash_report,use_animal_when_switch_view,scale_mode_in_nextchapter,enable_exit_button,
        use_http_or_https,engine,streaming_bwbx_float_window,streaming_bwbx_download_speed_limit,streaming_bwbx_download_use_multi_thread,
        after_user_permission,must_check_privacy,use_kwwd,dont_use_activity_task;

        public static Settings getSetting(String setting){
            Settings set = null;
            try {
                set = valueOf(setting.toLowerCase());
            } catch (IllegalArgumentException e) {
            }
            return set;
        }
    }

    /**
     * 解析所有配置项配置文件
     * @param configs 所有配置项
     */
    public static void init(Map<String, String> configs) {
        if (null == configs) {
            return;
        }
        for (String key : configs.keySet()) {
            String value = configs.get(key);
            Settings setting = Settings.getSetting(key);
            if (null == setting) {
                continue;
            }
            switch (setting) {
                case engine:
                    ENGINE = Integer.parseInt(value);
                    break;
                case selected_area:
                    SELECTED_AREA = (value.equalsIgnoreCase("0") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("2") || value.equalsIgnoreCase("3")) ? Integer.parseInt(value) : LBConfig.AREA_CN;
                    break;
                case use_lebian:
                    USE_LEBIAN = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : true;
                    break;
                case use_http_or_https:
                    USE_HTTP_OR_HTTPS = (value.equalsIgnoreCase("0") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("2")) ? Integer.parseInt(value) : LBConfig.HTTP;
                    break;
                case enable_crash_report:
                    ENABLE_CRASH_REPORT = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : true;
                    break;
                case use_animal_when_switch_view:
                    USE_ANIMAL_WHEN_SWITCH_VIEW = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : true;
                    break;
                case scale_mode_in_nextchapter:
                    SCALE_MODE_IN_NEXTCHAPTER = (value.equalsIgnoreCase("0") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("2")) ? Integer.parseInt(value) : 0;
                    break;
                case enable_exit_button:
                    ENABLE_EXIT_BUTTON = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                //热更
                case use_regeng:
                    USE_REGENG = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : true;
                    break;
                case download_after_quit:
                    DOWNLOAD_AFTER_QUIT = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : true;
                    break;
                case auto_check_newver_onstart:
                    AUTO_CHECK_NEWVER_ONSTART = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : true;
                    break;
                case newv_location:
                    NEWV_LOCATION = (value.equalsIgnoreCase("4") || value.equalsIgnoreCase("5") || value.equalsIgnoreCase("6")) ? Integer.parseInt(value) : LBConfig.LOCATION_AUTO;
                    break;
                case restart_after_new_raw_success:
                    RESTART_NEW_RAW = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                //分包
                case use_streaming:
                    USE_BWBX = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_handle_assetmanager:
                    HANDLE_ASSETMANAGER_BWBX = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_show_loading_progress:
                    SHOW_LOADING_PROGRESS_BWBX = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : true;
                    break;
                case streaming_show_loading_after_download_missing_time:
                    try {
                        SHOW_LOADING_AFTER_DOWNLOAD_MISSING_TIME = Integer.parseInt(value);
                    } catch (NumberFormatException e) {
                        SHOW_LOADING_AFTER_DOWNLOAD_MISSING_TIME = 15;
                        e.printStackTrace();
                    }
                    break;
                case streaming_show_first_dialog_without_wifi:
                    SHOW_FIRST_DIALOG_WITHOUT_WIFI_BWBX = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : true;
                    break;
                case streaming_show_first_dialog_always:
                    SHOW_FIRST_DIALOG_ALWAYS_BWBX = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_check_old_user_auto:
                    CHECK_OLD_USER_AUTO = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : true;
                    break;
                case streaming_old_user_missing_condition:
                    try {
                        OLD_USER_MISSING_CONDITION = Integer.parseInt(value);
                    } catch (NumberFormatException e) {
                        OLD_USER_MISSING_CONDITION = 20;
                        e.printStackTrace();
                    }
                    break;
                case streaming_show_old_user_count:
                    try {
                        SHOW_OLD_USER_COUNT = Integer.parseInt(value);
                    } catch (NumberFormatException e) {
                        SHOW_OLD_USER_COUNT = 3;
                        e.printStackTrace();
                    }
                    break;
                case streaming_twiceload:
                    CHOOSE_BY_USER_BWBX = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_twload_api_control:
                    TWLOAD_API_CONTROL = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_twiceload_force:
                    CHOOSE_BY_USER_BWBX_FORCE = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_download_full_after_second_dialog:
                    DOWNLOAD_FULL_AFTER_SECOND_DIALOG_BWBX = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_network_weak:
                    SHOW_DIALOG_NETWORK_WEAK_BWBX = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : true;
                    break;
                case streaming_show_dialog_with_wifi_when_twload:
                    SHOW_DIALOG_WITH_WIFI_WHEN_TWLOAD_BWBX = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_show_dialog_without_wifi_when_twload:
                    SHOW_DIALOG_WITHOUT_WIFI_WHEN_TWLOAD_BWBX = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_second_dialog_interval:
                    try {
                        SECOND_DIALOG_INTERVAL_BWBX = Integer.parseInt(value);
                    } catch (NumberFormatException e) {
                        SECOND_DIALOG_INTERVAL_BWBX = 0;
                        e.printStackTrace();
                    }
                    break;
                case streaming_show_dialog_button_by_old_user:
                    SHOW_DIALOG_BUTTON_BY_OLD_USER = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_twiceload_later:
                    CHOOSE_BY_USER_BWBX_LATER = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_show_dialog_without_wifi_when_twiceload_later:
                    SHOW_DIALOG_WITHOUT_WIFI_WHEN_LBRES_LATER = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : true;
                    break;
                case streaming_show_dailog_respatch_in_wifi:
                    SHOW_DIALOG_RESPATCH_IN_WIFI = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_show_progress_in_downloading_animation:
                    SHOW_PROGRESS_IN_DOWNLOADING_ANIMATION = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_load_local_res:
                    LOADING_LOCAL_RES = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_missing_size_limit:
                    try {
                        MISSING_SIZE_LIMIT = Integer.parseInt(value);
                    } catch (NumberFormatException e) {
                        MISSING_SIZE_LIMIT = 5;
                        e.printStackTrace();
                    }
                    break;
                case streaming_bwbx_float_window:
                    SHOW_BWBX_FLOAT_WINDOW = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_bwbx_download_speed_limit:
                    try {
                        BWBX_DOWNLOAD_SPEED_LIMIT = Integer.parseInt(value);
                    } catch (NumberFormatException e) {
                        BWBX_DOWNLOAD_SPEED_LIMIT = 0;
                        e.printStackTrace();
                    }
                    break;
                case streaming_bwbx_download_use_multi_thread:
                    BWBX_DOWNLOAD_USE_MULTI_THREAD = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case after_user_permission:
                    AFTER_USER_PERMISSION = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case must_check_privacy:
                    START_CHECK_PRIVACY_PERMISSION = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case use_kwwd:
                    USE_KWWD = (value.equalsIgnoreCase("true")  || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case streaming_control_first_dialog:
                    CONTROL_FIRST_DIALOG_BWBX = (value.equalsIgnoreCase("true")  || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
                case dont_use_activity_task:
                    DONT_USE_ACTIVITY_TASK = (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) ? Boolean.parseBoolean(value) : false;
                    break;
            }
        }

        // 原 refreshState 函数的内容
        android.util.Log.d("GlobalSettings", "USE_LEBIAN=" + USE_LEBIAN);
        if (USE_HTTP_OR_HTTPS == LBConfig.HTTPS_SELF && SELECTED_AREA == LBConfig.AREA_TW) {
            USE_HTTP_OR_HTTPS = 2;
        }
    }
}

