package com.example.lebianecdemo;

import android.app.Activity;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.content.FileProvider;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

import com.excelliance.lbsdk.IQueryUpdateCallback;
import com.excelliance.lbsdk.LebianSdk;

public class MainActivity extends Activity {
	private TextView rt;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		FileProvider f;

		Button bt = (Button) findViewById(R.id.bt);
		rt = (TextView) findViewById(R.id.result);
		int vc = 0;
		try {
			TextView tv = (TextView) findViewById(R.id.tv);
			vc = getPackageManager().getPackageInfo(getPackageName(), 0).versionCode;
			tv.setText("currentVersionCode=" + vc);
		} catch (PackageManager.NameNotFoundException e) {
			e.printStackTrace();
		}
		try {
			TextView tv3 = (TextView) findViewById(R.id.tv3);
			tv3.setText("afterHotUpdate: " + LebianSdk.afterUpdate());
		} catch (Exception e) {
			e.printStackTrace();
		}
		try {
			PackageInfo info = LebianSdk.getHostPackageInfo(getApplicationContext());
			if (info != null) {
				TextView tv2 = (TextView) findViewById(R.id.tv2);
				tv2.setText("installedVersionCode=" + info.versionCode);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		
		Log.d("SDKDEMO", "MainActivity onCreate");

		bt.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				queryUpdate();
			}
		});
	}

	protected void queryUpdate() {
		Log.d("MainActivity", "queryUpdate");
		final IQueryUpdateCallback callBack = new IQueryUpdateCallback() {
			public void onUpdateResult(int result) {
				Log.d("MainActivity", "onResume result=" + result);
				if (rt != null) {
					rt.setText("result: " + result);
				}

			}
		};
		LebianSdk.queryUpdate(this, callBack, null);
	}

}
